/*
 * Decompiled with CFR 0.152.
 */
package eu.kliegr.ac1.data;

import eu.kliegr.ac1.data.Attribute;
import eu.kliegr.ac1.data.AttributeType;
import eu.kliegr.ac1.data.AttributeValue;
import eu.kliegr.ac1.data.AttributeValueType;
import eu.kliegr.ac1.data.Combinations;
import eu.kliegr.ac1.data.Transaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class DataTable {
    private static final Logger LOGGER = Logger.getLogger(DataTable.class.getName());
    private final ArrayList<Attribute> attribute_byPosition = new ArrayList();
    private final ConcurrentHashMap<String, Attribute> attributes = new ConcurrentHashMap();
    private final ArrayList<Transaction> transactions = new ArrayList();
    private ArrayList<Transaction> hiddenTransactions = new ArrayList();
    private Attribute target;
    private Attribute id;
    int loadedTransactions = 0;
    private int lastAID = -1;
    public final int firstTID = 0;
    private int lastTID = -1;

    public DataTable(String[] colNames, String targetColName, ArrayList<AttributeType> attributeTypes, String IDcolumnName) throws Exception {
        int i = -1;
        for (String col : colNames) {
            if (col.contains("=")) {
                throw new Exception("Column name cannot contain =.");
            }
            boolean targetFlag = col.equals(targetColName);
            boolean idColumnFlag = col.equals(IDcolumnName);
            Attribute att = Attribute.makeAttribute(col, targetFlag, attributeTypes.get(++i), idColumnFlag, ++this.lastAID);
            this.attributes.put(att.getName(), att);
            this.attribute_byPosition.add(att);
            if (targetFlag) {
                this.target = att;
            }
            if (!idColumnFlag) continue;
            this.id = att;
        }
        this.checkDataTable(IDcolumnName, attributeTypes);
    }

    public Attribute getTargetAttribute() {
        return this.target;
    }

    public Attribute getAttribute(String name) {
        return this.attributes.get(name);
    }

    public int getLoadedTransactionCount() {
        return this.loadedTransactions;
    }

    public int getCurrentTransactionCount() {
        return this.transactions.size();
    }

    public ArrayList<Transaction> getAllCurrentTransactions() {
        return this.transactions;
    }

    public void removeAllTransactions(boolean hide) {
        while (this.transactions.size() > 0) {
            this.removeTransaction(this.transactions.get(0), hide);
        }
    }

    public void unhideAllTransactions() {
        this.hiddenTransactions.stream().map(t -> {
            t.reregisterWithAllAttributeValues();
            return t;
        }).forEach(t -> this.transactions.add((Transaction)t));
        this.hiddenTransactions = new ArrayList();
    }

    public void removeTransaction(Transaction t, Boolean hide) {
        t.deregisterFromAllAttributeValues();
        this.transactions.remove(t);
        if (hide.booleanValue()) {
            this.hiddenTransactions.add(t);
        }
    }

    public float getMinSupportThreshold(int numberOfOneItemsets) {
        float relSupport;
        List supps = this.attribute_byPosition.stream().filter(a -> !a.isTargetAttribute).map(attribute -> attribute.getNumberOfValuesWithSupport()).flatMap(l -> l.stream()).collect(Collectors.toList());
        Collections.sort(supps);
        if (supps.size() <= numberOfOneItemsets) {
            relSupport = 0.0f;
        } else {
            long absoluteSupport = ((Integer)supps.get(supps.size() - numberOfOneItemsets)).intValue();
            relSupport = (float)absoluteSupport / (float)this.loadedTransactions;
        }
        LOGGER.log(Level.INFO, "Determined relative support to obtain maximum {0}  one itemsets:{1}", new Object[]{numberOfOneItemsets, Float.valueOf(relSupport)});
        return relSupport;
    }

    public long getMaxCombinationCount(int targetSupport, long maxlen) {
        ArrayList freqs = this.attribute_byPosition.stream().map(attribute -> attribute.getNumberOfValuesWithMinSupport(targetSupport)).collect(Collectors.toCollection(ArrayList::new));
        long itemcount = 0L;
        Iterator iterator = freqs.iterator();
        while (iterator.hasNext()) {
            int freq = (Integer)iterator.next();
            itemcount += (long)freq;
        }
        return Combinations.choose(itemcount, maxlen);
    }

    public Attribute getAttribute(int position) {
        return this.attribute_byPosition.get(position);
    }

    private Transaction makeTransaction(String[] vector) {
        Transaction t = new Transaction(++this.lastTID, 0);
        return t;
    }

    public void addTransaction(String[] vector) throws NumberFormatException {
        Transaction t = this.makeTransaction(vector);
        this.transactions.add(t);
        ++this.loadedTransactions;
        for (int i = 0; i < vector.length; ++i) {
            Attribute at = this.getAttribute(i);
            AttributeValue attributeValue = null;
            try {
                attributeValue = at.getValueByString(vector[i]);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.INFO, "NumberFormatException for value {0}", vector[i]);
                throw e;
            }
            if (attributeValue == null) {
                try {
                    at.addNewValue(vector[i], t, AttributeValueType.dataBacked);
                    continue;
                }
                catch (NumberFormatException e) {
                    LOGGER.log(Level.INFO, "NumberFormatException for value {0}", vector[i]);
                    at.addNewValue(vector[i], t, AttributeValueType.dataBacked);
                    throw e;
                }
            }
            attributeValue.addTransaction(t, true);
        }
    }

    public void printDataTable() {
        this.attributes.values().stream().forEach(at -> LOGGER.info(at.toString()));
    }

    private void checkDataTable(String IDcolumnName, ArrayList<AttributeType> attributeTypes) throws Exception {
        if (this.target == null) {
            throw new Exception("Target variable not specified or found");
        }
        if (this.attributes.size() < 2) {
            throw new Exception("No predictor specified");
        }
        if (IDcolumnName != null && this.id == null) {
            throw new Exception("ID column not found");
        }
        if (attributeTypes.size() != this.attributes.size()) {
            throw new Exception("Mismatch in the number of specified attribute types (" + attributeTypes.size() + ") and detected attributes (" + this.attributes.size() + ")");
        }
    }

    public Attribute getIDAttribute() {
        return this.id;
    }
}

