% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pvlrt-wrappers.R
\name{lrt_zi_poisson}
\alias{lrt_zi_poisson}
\title{Pseudo Likelihood Ratio Test under the
zero-inflated Poisson model with relative reporting rate parametrization}
\usage{
lrt_zi_poisson(contin_table, nsim = 10000, ...)
}
\arguments{
\item{contin_table}{IxJ contingency table showing pairwise counts of adverse
events for I AE (along the rows) and J Drugs (along the columns)}

\item{nsim}{Number of simulated null contingency table to use for computing
the p-value of the test}

\item{...}{additional arguments passed to pvlrt}
}
\value{
Returns a \code{pvlrt} object. See \link{pvlrt} for more details.
}
\description{
Pseudo Likelihood Ratio Test under the
zero-inflated Poisson model with relative reporting rate parametrization
}
\note{
\code{lrt_zi_poisson()} is a wrapper for \code{pvlrt()} with
\code{parametrization = "rrr"}.
}
\examples{

data("statin46")

# 500 bootstrap iterations (nsim) in the example below
# are for quick demonstration only --
# we recommended setting nsim to 10000 (default) or bigger
test1 <- lrt_zi_poisson(statin46, nsim = 500)
test1

}
\seealso{
\link{pvlrt}
}
