% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/particlefilter.R
\name{procfun_ct}
\alias{procfun_ct}
\title{continuous-time process noise function}
\usage{
procfun_ct(sp, xt, waiting_time = 1, time = NULL)
}
\arguments{
\item{sp}{a numeric vector of length two or three, where terms 1-2 specify either the log-transformed standard deviation of the process noise function,
or an intercept and slope for calculating variance of process noise based on a power function of x, of the form var=exp(B0)*x^exp(B1)
The final term in the vector represents the recovery rate - i.e. the continuous time rate at which abundances recover from perturbation}

\item{xt}{a number or numeric vector of abundances at time t, before process noise has occurred}

\item{waiting_time}{average time between disturbance events: defaults to 1}

\item{time}{the timestep - defaults to NULL (i.e. not used)}
}
\value{
a number or numeric vector of length xt, with predicted abundances after process noise has occurred
}
\description{
Simulates effects of process noise following a Gaussian perturbation.
Note that process noise only influences positive abundances (i.e. process noise cannot contribute to colonization)
}
\keyword{noise}
\keyword{process}
