% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/particlefilter.R
\name{particleFilterLL}
\alias{particleFilterLL}
\title{particle filter}
\source{
Adapted from Knape and Valpine (2012), Ecology 93:256-263.
}
\usage{
particleFilterLL(
  y,
  pars,
  N = 1000,
  detfun = detfun0,
  procfun = procfun0,
  obsfun = obsfun0,
  colfun = colfun0,
  edmdat = NULL,
  dotraceback = FALSE,
  fulltraceback = FALSE
)
}
\arguments{
\item{y}{A numeric vector of observed values, from which the likelihood of parameters and functions will be determined.}

\item{pars}{A list of parameter values. Must include elements obs (observation error parameters), proc (process noise parameters), and pcol (colonization parameters), which are passed on the their respecive functions, described below. If edmdat=NULL, then element det (deterministic process parameters) must be included.}

\item{N}{Number of particles to simulate. Defaults to 1e3.}

\item{detfun}{A function that simulates deterministic dynamics, which takes in arguments sdet (parameters for deterministic model, taken from pars$proc), and xt, observed abundances at time t. Returns estimated abundances at time t+1 based on deterministic function (either a parametric function or an EDM function). Defaults to detfun0.}

\item{procfun}{A function that simulates process noise, which takes in arguments sp (parameters for process noise function, taken from pars$proc) and xt (abundances prior to process noise). Returns abundances after process noise has occurred. Defaults to procfun0.}

\item{obsfun}{An observation function, which takes in up to five variables, including so (a vector of parameter values, inherited from pars$obs), yt (a number, showing observed abundance at time t), xt (predicted abundances), binary value "inverse", and number "N". If inverse = TRUE,
then function should simulate N draws from the observation function, centered around value yt. If inverse = FALSE, then function should return log probability denisty of observed value yt given predicted values in xt. Defaults to obsfun0.}

\item{colfun}{A function simulating colonization events, that takes in two arguments: co, a vector of parameter values taken from pars$pcol, and xt, a number or numeric vector of abundances at time t, before colonization has occurred. Returns predicted abundances after colonization has occurred. Defaults to colful0.}

\item{edmdat}{A list including arguments to be passed to block_lnlp from rEDM package - see block_lnlp help file for details. Can also include optional matrix "extra_columns", a matrix with length(y) rows including extra covariates for attractor reconstruction, which defaults to NULL (i.e. no additional columns).
Default for edmdat is NULL, which implies that EDM will not be applied - instead, a detfun and pars$det must be included.}

\item{dotraceback}{A logical, indicating whether estimated values and demographic rates should be reported - defaults to FALSE}

\item{fulltraceback}{A logical, indicating whether full matrix of particles for all time steps should be returned.}
}
\value{
LL (total log likelihood), LLlst (log likelihood for each time step), Nest (mean estimated state), Nsd (standard deviation of estimated state), Nest_noproc (mean estimated state at time t+1 without process error), Nsd_noproc (standard deviation of estimated state at time t+1 without process error),
fulltracemat (full traceback of particle paths), fulltracemat_noproc (full traceback of particle paths at time t+1 without process noise), and fulltraceindex (index positions for the particle traces over time)
}
\description{
General function for caluclating the log-likeihood of a stochastic discrete-time model,
based on a noisy observation of time-series y. Returns estimates of true values of y, as well as for process noise, observation error, colonization rates, and extinction rates.
Function is adapted from the R code of Knape and Valpine (2012), Ecology 93:256-263.
}
\keyword{Taylor}
\keyword{filter}
\keyword{law}
\keyword{particle}
\keyword{power}
\keyword{stability}
\keyword{time-series}
