% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psychrolib.R
\name{GetTDewPointFromTWetBulb}
\alias{GetTDewPointFromTWetBulb}
\title{Return dew-point temperature given dry-bulb temperature, wet-bulb temperature, and pressure.}
\usage{
GetTDewPointFromTWetBulb(TDryBulb, TWetBulb, Pressure)
}
\arguments{
\item{TDryBulb}{A numeric vector of dry-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{TWetBulb}{A numeric vector of wet-bulb temperature in degreeF [IP] or degreeC [SI]}

\item{Pressure}{A numeric vector of atmospheric pressure in Psi [IP] or Pa [SI]}
}
\value{
A numeric vector of dew-point temperature in degreeF [IP] or degreeC [SI]
}
\description{
Return dew-point temperature given dry-bulb temperature, wet-bulb temperature, and pressure.
}
\examples{
SetUnitSystem("IP")
GetTDewPointFromTWetBulb(80:100, 65.0, 14.696)

SetUnitSystem("SI")
GetTDewPointFromTWetBulb(25:40, 20, 101325.0)

}
\references{
ASHRAE Handbook - Fundamentals (2017) ch. 1
}
