\name{schmid}
\alias{schmid}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Apply the Schmid Leiman transformation to a correlation matrix}
\description{One way to find omega is to do a factor analysis of the original data set, rotate the factors obliquely, do a Schmid Leiman transformation, and then find omega. Here is the code for Schmid Leiman.  The S-L transform takes a factor or PC solution, transforms it to an oblique solution, factors the oblique solution to find a higher order (g ) factor, and then residualizes g out of the the group factors.

}
\usage{
schmid(model, nfactors = 3, pc = "pa",digits=2,rotate="oblimin",n.obs=NA,...)
}

\arguments{
  \item{model}{ A correlation matrix }
  \item{nfactors}{ Number of factors to extract }
  \item{pc}{ pc="pa" for principal axes, pc="pc" for principal components, pc="mle" for maximum likelihood }
  \item{digits}{if digits not equal NULL, rounds to digits}
  \item{rotate}{The default, oblimin, produces somewhat more correlated factors than the alternative, simplimax. Although it is possible to use promax as a rotation option, these seems to produce very poor results and is discouraged.}
  \item{n.obs}{Number of observations, used to find fit statistics if specified.  Will be calculated if input is raw data}
  \item{...}{Allows additional parameters to be passed to the factoring routines}
}
\details{Schmid Leiman orthogonalizations are typical in the ability domain, but are not seen as often in the non-cognitive personality domain.  S-L is one way of finding the loadings of items on the general factor for estimating omega. 

A typical example would be in the study of anxiety and depression.  A general neuroticism factor (g) accounts for much of the variance, but smaller group factors of tense anxiety, panic disorder, depression, etc. also need to be considerd.

An alternative model is to consider hierarchical cluster analysis techniques such as \code{\link{ICLUST}}.

Requires the GPArotation package.

Although 3 factors are the minimum number necessary to define the solution uniquely, it is occasionally useful to allow for a two factor solution.  This is  done here by setting the general factor loadings between the two lower order factors as the sqrt(oblique correlations between the factors). A warning message is issued. 
}
\value{
  
  \item{sl }{loadings on g + nfactors group factors, communalities, uniqueness}
  \item{orthog }{original orthogonal factor loadings}
  \item{oblique}{oblique factor loadings}
  \item{phi }{correlations among the transformed factors}
   \item{gload }{loadings of the lower order factors on g}
  ...
}
\references{\url{http://personality-project.org/r/r.omega.html} gives an example taken from Jensen and Weng, 1994 of a S-L transformation.}
\author{ William Revelle}

\seealso{  \code{\link{omega}}, \code{\link{omega.graph}}, \code{\link{fa.graph}}, \code{\link{ICLUST}},\code{\link{VSS}}}
\examples{
s.jen <- schmid(make.hierarchical(),digits=2)  #create a hierarchical demo
s.jen
}
\keyword{ multivariate }% at least one, from doc/KEYWORDS
\keyword{ models }% __ONLY ONE__ keyword per line
