% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effective_functions.r
\name{optCL}
\alias{optCL}
\title{Calculate the Optimal Visual Testing Confidence Level}
\usage{
optCL(
  obj = NULL,
  b = NULL,
  v = NULL,
  level = 0.95,
  grid_range = c(0.75, 0.99),
  grid_length = 100,
  adjust = p.adjust.methods[c(8, 1:7)],
  print_message = TRUE,
  ...
)
}
\arguments{
\item{obj}{A model object, on which \code{coef} and \code{vcov} can be called. 
Either \code{obj} and \code{varname} or \code{b} and \code{v} must be specified.}

\item{b}{Optional vector of coefficients to be passed into the function.
it overrides the coefficients in \code{obj}. Either \code{obj} or \code{b} 
and \code{v} must be specified.}

\item{v}{Optional variance-covariance matrix.  This can be specified 
even if \code{obj} and \code{varname} are specified.  It replaces the
variance-covaraince matrix from the model.}

\item{level}{The confidence level to use for testing.}

\item{grid_range}{The range of values over which to do the grid search.}

\item{grid_length}{The number of values in the grid.}

\item{adjust}{String giving the method used to adjust the p-values for 
multiplicity.  All methods allowed in \code{p.adjust.methods} are 
permitted.  None is the default.}

\item{print_message}{Logical indicating whether the startup message directing
users to a newer version of this function and package}

\item{...}{Other arguments to be passed down to `VizTest::viztest()`.}
}
\value{
A list (of class "viztest") with the following elements: 
1. tab: a data frame with results from the grid search.  The data frame has four variables: `level` - is the confidence level used in the grid search; `psame` - the proportion of (non-)overlaps that match the 
normal theory tests; `pdiff` - the proportion of pairwise tests that are statistically significant; `easy` - the ease with which the comparisons are made. 
2. pw_tests: A logical vector indicating which tests are significantly significant. 
3. ci_tests: A logical vector indicating whether the confidence intervals are disjoint (`TRUE`) or overlap (`FALSE`). 
4. combs: The pairwise combinations of stimuli used in the test.  Note, the stimuli are reordered from largest to smallest, so the numbers do not represent the position in the original ordering. 
5. param_names: A vector of the names of the parameters reordered by size - largest to smallest. 
6. L: The lower confidence bounds from the grid search. 
7. U: The upper confidence bounds from the grid search. 
8. est: A data frame with the variables `vbl` - the parameter name; `est` - the parameter estimate; `se` - the parameter standard error. 
9. call: model call
}
\description{
Calculates the Optimal Visual Testing (OVT) confidence level.  The
OVT level is a level you can use to make confidence intervals such that
the overlapping (or non-overlapping) of confidence intervals preserves
the pairwise testing results. That is, statistically different 
estimates have confidence intervals that do not overlap and statistically
indistinguishable intervals have confidence intervals that do overlap. 
It does not always work perfectly, but it generally results in fewer
inferential errors than the nominal level.
}
\examples{
data(wvs)
wvs$civ2 <- "Other"
wvs$civ2 <- ifelse(wvs$civ == 9, 
                   "Western", 
                   wvs$civ2)
wvs$civ2 <- ifelse(wvs$civ == 6, 
                   "Latin American", 
                   wvs$civ2)
wvs$civ2 <- as.factor(wvs$civ2)

intmod <- lm(resemaval ~ civ2 * pct_secondary, 
             data=wvs)

ss2 <- simple_slopes(intmod, 
                     "pct_secondary", 
                     "civ2")
o2 <- optCL(b=ss2$est$slope, v=ss2$v)
}
