% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_D2.R
\name{pool_D2}
\alias{pool_D2}
\title{Combines the Chi Square statistics across Multiply Imputed datasets}
\usage{
pool_D2(dw, v)
}
\arguments{
\item{dw}{a vector of Chi square values obtained after multiple imputation.}

\item{v}{single value for the degrees of freedom of the Chi square statistic.}
}
\value{
The pooled chi square values as the D2 statistic, the p-value,
 the numerator, df1 and denominator, df2 degrees of freedom for the
 F-test.
}
\description{
\code{pool_D2} The D2 statistic to combine the Chi square values 
 across Multiply Imputed datasets.
}
\examples{
  pool_D2(c(2.25, 3.95, 6.24, 5.27, 2.81), 4) 
 
}
\references{
Eekhout I, van de Wiel MA, Heymans MW. Methods for significance testing of categorical
  covariates in logistic regression models after multiple imputation: power and applicability
  analysis. BMC Med Res Methodol. 2017;17(1):129.

Van Buuren S. (2018). Flexible Imputation of Missing Data. 2nd Edition. Chapman & Hall/CRC
  Interdisciplinary Statistics. Boca Raton.
}
\author{
Martijn Heymans, 2021
}
