% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post-estimation.R
\name{calc_STG}
\alias{calc_STG}
\title{Calculate the Standardized total gain}
\usage{
calc_STG(psdesign, t, sig.level = 0.05, n.samps = 5000, bootstraps = TRUE,
  permute = TRUE, permute.times = 2000, progress.bar = TRUE)
}
\arguments{
\item{psdesign}{A psdesign object. It must contain a risk model, an
integration model, and estimated parameters. Bootstrapped parameters are
optional}

\item{t}{For time to event outcomes, a fixed time \code{t} may be provided to
compute the cumulative distribution function. If not, the restricted mean
survival time is used. Omit for binary outcomes.}

\item{sig.level}{Significance level for bootstrap confidence intervals}

\item{n.samps}{The number of samples to take over the range of S.1 at which
the VE is calculated}

\item{bootstraps}{If true, and bootstrapped estimates are present, will
calculate bootstrap standard errors and confidence interval.}

\item{permute}{Not used, included for backwards compatibility}

\item{permute.times}{Not used, included for backwards compatibility}

\item{progress.bar}{Not used, included for backwards compatibility}
}
\description{
Computes the standardized total gain for the risk difference. Optionally produces bootstrap standard errors and confidence intervals. The standardized total gain is the area between the risk difference curve and the horizontal line at the marginal risk difference. If the outcome is time to event then the STG is time-dependent, and a time point for evaluation is needed. If one is not provided then the restricted mean survival is estimated from the data and used.
}

