% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ParadoxicalRanks}
\alias{ParadoxicalRanks}
\title{Artifical data of 54 subjects}
\format{
A data frame with 54 rows and 2 variables.
}
\usage{
data(ParadoxicalRanks)
}
\description{
An artificial dataset containing data of 54 subjects where where a substance was administered in three different concentrations (1,2 and 3).
This data set can be used to show the paradoxical results obtained from rank tests, i.e., the Hettmansperger-Norton test.
}
\details{
The columns are as follows:
\itemize{
  \item conc. Grouping variable specifying which concentration was used. This factor is ordered, i.e., 1 < 2 < 3.
  \item score. The response variable.
}
}
\examples{
data("ParadoxicalRanks")
dat <- ParadoxicalRanks

set.seed(1)
n <- c(60, 360, 120)
x1 <- sample(subset(dat, dat$conc == 1)$score, n[1], replace = TRUE)
x2 <- sample(subset(dat, dat$conc == 2)$score, n[2], replace = TRUE)
x3 <- sample(subset(dat, dat$conc == 3)$score, n[3], replace = TRUE)


dat <- data.frame(score = c(x1, x2, x3),
  conc = factor(c( rep(1,n[1]), rep(2,n[2]), rep(5,n[3]) ), ordered=TRUE) )

# Hettmansperger-Norton test with ranks (pseudorannks = FALSE) returns a small p-value (0.011).
# In contrast, the pseudo-rank test returns a large p-value (0.42). By changing the ratio of
# group sizes, we can also obtain a significant decreasing trend with ranks, e.g.
# n <- c(260,20,260) and the same seed.
hettmansperger_norton_test(score ~ conc, data = dat, pseudoranks = FALSE,
  alternative = "increasing")
hettmansperger_norton_test(score ~ conc, data = dat, pseudoranks = TRUE,
  alternative = "increasing")
}
\references{
Happ M, Zimmermann G, Brunner E, Bathke AC (2020). Pseudo-Ranks: How to Calculate Them Efficiently in R. Journal of Statistical Software, Code Snippets, *95*(1), 1-22. doi: 10.18637/jss.v095.c01 (URL:https://doi.org/10.18637/jss.v095.c01).
}
\keyword{datasets}
