% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLUE.R
\name{PLUE}
\alias{PLUE}
\alias{print.PLUE}
\alias{plot.PLUE}
\title{Profiled Likelihood Uncertainty Estimation}
\usage{
PLUE(model = NULL, factors, N, LL, start, res.names = NULL,
  method = c("internal", "mcmc"), opts = list(), nboot = 0,
  repetitions = 1, cl = NULL)

\method{print}{PLUE}(x, ...)

\method{plot}{PLUE}(x, ...)
}
\arguments{
\item{model}{The function to be run, representing the model or simulation.}

\item{factors}{The names of the input variables (used for naming the 'data' data.frame and in plotting)
Either a vector of strings or a single number representing the number of factors}

\item{N}{The number of samples to be generated by the Metropolis algorithm.}

\item{LL}{The POSITIVE Likelihood function to be used by the Metropolis algorithm. It must accept
an array with length equal to the number of factors.}

\item{start}{The initial point to be evaluated. Must have the same length as the number of factors.}

\item{res.names}{Optional: what are the names of the model results? (Used mainly for plotting)}

\item{method}{May be either "internal", which runs a naive and inneficient algorithm provided for test
and didatic purposes, or "mcmc", which will run the \code{metrop} function from the \code{mcmc} package.}

\item{opts}{Further options to be passed to the Metropolis function. See the help on 
\code{\link[mcmc]{metrop}}.}

\item{nboot}{Number of bootstrap replicates for calculating the PRCC.}

\item{repetitions}{The number of model repetitions to be run for a single data point. See the vignette on 
stochastic models for details}

\item{cl}{Cluster generated with the ``parallel'' library. May be of any type supported.
    If a cluster is provided, the model will be run in parallel or distributed across
    the cluster via clusterApply. No load balancing is provided, so the model results are
    reproducible.

    NOTE: You should manually export ALL objects required for the model to run, including the model
    function itself. See the help on \code{clusterExport} on package \code{parallel} for
    details.}

\item{x}{An LHS/PLUE object. For "tell", an incomplete LHS object (created with model=NULL)}

\item{...}{Currently ignored}
}
\description{
Performs a likelihood-based uncertainty estimation on a model. This analysis consists
on a Metropolis Monte Carlo exploration of the parameter space and subsequent profiling
of model results based on the likelihood of the input parameters.
}
\details{
A detailed description can be found on Chalom & Prado (2015).
}
\references{
Chalom, A. and Prado, P.I.K.L. 2015. Uncertainty analysis and composite 
 hypothesis under the likelihood paradigm. \emph{arXiv}:1508.03354 [q-bio.QM]
}
