% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_ranked_intensities.R
\name{qc_ranked_intensities}
\alias{qc_ranked_intensities}
\title{Check ranked intensities}
\usage{
qc_ranked_intensities(
  data,
  sample,
  grouping,
  intensity_log2,
  facet = FALSE,
  plot = FALSE,
  y_axis_transformation = "log10",
  interactive = FALSE
)
}
\arguments{
\item{data}{a data frame that contains at least sample names, grouping identifiers (precursor,
peptide or protein) and log2 transformed intensities for each grouping identifier.}

\item{sample}{a character column in the \code{data} data frame that contains the sample names.}

\item{grouping}{a character column in the \code{data} data frame that contains protein, precursor,
or peptide identifiers.}

\item{intensity_log2}{a numeric column in the \code{data} data frame that contains the log2
transformed intensities of the selected grouping variable.}

\item{facet}{a logical value that specifies whether the calculation should be done group wise by
sample and if the resulting plot should be faceted by sample. (default is \code{FALSE}).
If \code{facet = FALSE} the median of each protein intensity will be returned.}

\item{plot}{a logical value that specifies whether the result should be plotted (default is \code{FALSE}).}

\item{y_axis_transformation}{a character value that determines that y-axis transformation. The
value is either "log2" or "log10" (default is "log10").}

\item{interactive}{a logical value that specifies whether the plot should be interactive
(default is \code{FALSE}).}
}
\value{
A data frame containing the ranked intensities is returned. If \code{plot = TRUE} a plot
is returned. The intensities are log10 transformed for the plot.
}
\description{
Calculates and plots ranked intensities for proteins, peptides or precursors.
}
\examples{
set.seed(123) # Makes example reproducible

# Create synthetic data
data <- create_synthetic_data(
  n_proteins = 50,
  frac_change = 0.05,
  n_replicates = 4,
  n_conditions = 3,
  method = "effect_random",
  additional_metadata = FALSE
)

# Plot ranked intensities for all samples combined
qc_ranked_intensities(
  data = data,
  sample = sample,
  grouping = peptide,
  intensity_log2 = peptide_intensity,
  plot = TRUE,
)

# Plot ranked intensities for each sample separately
qc_ranked_intensities(
  data = data,
  sample = sample,
  grouping = peptide,
  intensity_log2 = peptide_intensity,
  plot = TRUE,
  facet = TRUE
)

}
