% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_missed_cleavages.R
\name{qc_missed_cleavages}
\alias{qc_missed_cleavages}
\title{Check missed cleavages}
\usage{
qc_missed_cleavages(
  data,
  sample,
  grouping,
  missed_cleavages,
  intensity,
  remove_na_intensities = TRUE,
  method = "count",
  plot = FALSE,
  interactive = FALSE
)
}
\arguments{
\item{data}{a data frame containing at least sample names, peptide or precursor identifiers
and missed cleavage counts for each peptide or precursor.}

\item{sample}{a character or factor column in the \code{data} data frame that contains the sample name.}

\item{grouping}{a character column in the \code{data} data frame that contains either precursor or
peptide identifiers.}

\item{missed_cleavages}{a numeric column in the \code{data} data frame that contains the counts
of missed cleavages per peptide or precursor.}

\item{intensity}{a numeric column in the \code{data} data frame that contains the corresponding
raw or normalised intensity values (not log2) for each peptide or precursor. Required when
"intensity" is chosen as the method.}

\item{remove_na_intensities}{a logical value that specifies if sample/grouping combinations with
intensities that are NA (not quantified IDs) should be dropped from the data frame for analysis
of missed cleavages. Default is TRUE since we are usually interested in quantifiable peptides.
This is only relevant for method = "count".}

\item{method}{a character value that indicates the method used for evaluation. "count"
calculates the percentage of missed cleavages based on counts of the corresponding peptide or
precursor, "intensity" calculates the percentage of missed cleavages by intensity of the
corresponding peptide or precursor.}

\item{plot}{a logical value that indicates whether the result should be plotted.}

\item{interactive}{a logical value that specifies whether the plot should be interactive
(default is FALSE).}
}
\value{
A data frame that contains the calculated percentage made up by the sum of all peptides
or precursors containing the corresponding amount of missed cleavages.
}
\description{
Calculates the percentage of missed cleavages for each sample (by count or intensity). The
default settings remove grouping variables without quantitative information (intensity is NA).
These will not be used for the calculation of missed cleavage percentages.
}
\examples{
library(dplyr)

set.seed(123) # Makes example reproducible

# Create example data
data <- create_synthetic_data(
  n_proteins = 100,
  frac_change = 0.05,
  n_replicates = 3,
  n_conditions = 2,
  method = "effect_random"
) \%>\%
  mutate(intensity_non_log2 = 2^peptide_intensity_missing)

# Calculate missed cleavage percentages
qc_missed_cleavages(
  data = data,
  sample = sample,
  grouping = peptide,
  missed_cleavages = n_missed_cleavage,
  intensity = intensity_non_log2,
  method = "intensity",
  plot = FALSE
)

# Plot missed cleavages
qc_missed_cleavages(
  data = data,
  sample = sample,
  grouping = peptide,
  missed_cleavages = n_missed_cleavage,
  intensity = intensity_non_log2,
  method = "intensity",
  plot = TRUE
)
}
