% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_proteome_coverage.R
\name{qc_proteome_coverage}
\alias{qc_proteome_coverage}
\title{Proteome coverage per sample and total}
\usage{
qc_proteome_coverage(
  data,
  sample,
  protein_id,
  organism_id,
  plot = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{data}{A data frame containing at least sample names and protein ID's.}

\item{sample}{The column in the data data frame containing the sample name.}

\item{protein_id}{The column in the data data frame containing protein identifiers such as UniProt accessions.}

\item{organism_id}{The NCBI taxonomy identifier (TaxId) of the organism used. Human: 9606, S. cerevisiae: 559292, E. coli: 83333.}

\item{plot}{A logical indicating whether the result should be plotted (default is TRUE).}

\item{interactive}{A logical indicating whether the plot should be interactive (default is FALSE).}
}
\value{
A bar plot showing the percentage of of the proteome detected and undetected in total and for each sample. If \code{plot = FALSE} a data frame containing the numbers is returned.
}
\description{
Calculates the proteome coverage for each samples and for all samples combined. In other words the fraction of detected proteins to all proteins in the proteome is calculated.
}
\examples{
\dontrun{
qc_proteome_coverage(
  data,
  sample = r_file_name,
  protein_id = pg_protein_accession,
  organism_id = 9606
)
}
}
