% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qc_intensity_distribution.R
\name{qc_intensity_distribution}
\alias{qc_intensity_distribution}
\title{Check intensity distribution per sample and overall}
\usage{
qc_intensity_distribution(
  data,
  sample = NULL,
  grouping,
  intensity_log2,
  plot_style
)
}
\arguments{
\item{data}{A data frame containing at least sample names, grouping identifiers (precursor, peptide or protein) and
log2 transformed intensities for each grouping identifier.}

\item{sample}{The column in the data frame containing the sample name. NOTE: If the overall distribution should be returned please
do not provide the name of the sample column.}

\item{grouping}{The column in the data frame containing either precursor, peptide or protein identifiers.}

\item{intensity_log2}{The column in the data frame containing the log2 transformed intensities of each grouping identifier sample combination.}

\item{plot_style}{A character vector indicating the plot type. This can be either "histogram", "boxplot" or "violin". Plot style "boxplot" and "violin" can
only be used if a sample column is provided.}
}
\value{
A histogram or boxplot that shows the intensity distribution over all samples or by sample.
}
\description{
Plots the overall or sample-wise distribution of all peptide intensities as a boxplot or histogram.
}
\examples{
\dontrun{
qc_intensity_distribution(
  data,
  sample = r_file_name,
  grouping = eg_precursor_id,
  intensity_log2 = normalised_intensity_log2,
  plot_style = "boxplot"
)
}
}
