% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop2prob.R
\name{prop2prob}
\alias{prop2prob}
\title{Calculate Probability from Proportionality}
\usage{
prop2prob(x, y, method = "bonferroni", prompt = TRUE)
}
\arguments{
\item{x}{A \code{propr} object.}

\item{y}{A \code{propr} object. Optional.}

\item{method}{A character string. Selects method used to
adjust p-values for multiple comparisons. Argument
passed to \code{\link{p.adjust}}. Defaults to the
more conservative Bonferroni correction.}

\item{prompt}{A logical scalar. Set to \code{FALSE} to disable
the courtesy prompt when working with big data.}
}
\value{
Returns a \code{data.table} of p-values.
}
\description{
This experimental helper function calculates probability from
 proportionality. When supplying one \code{propr} object,
 \code{prop2prob} estimates the probability that
 each proportionality coefficient occurred by chance alone.
 When supplying two \code{propr} objects, \code{prop2prob}
 estimates the probability that each proportionality
 coefficient differs between the two objects.
}
\details{
All calculations use formulae derived for the concordance
 correlation coefficient under the constraint that all means
 equal zero. We defend this constraint on the grounds that
 we can shift the mean of log-ratio transformed feature vectors
 without changing the proportionality coefficient, rho, or
 Pearson's correlation coefficient, r. We refer the reader to
 Zar's Biostatistical Analysis text (4ed, pg 407-10) for
 more information on the method used.

When calculating differential proportionality, it is the
 responsibility of the user to ensure that the two groups
 have no overlapping samples. All p-values returned as
 twice the result of \code{\link{pnorm}}, thereby correcting
 for "two-tails". Please make sure to interpret p-values
 in the context of multiple testing! For more information,
 see \code{\link{p.adjust}}.
}
\examples{
library(propr)
data(mail)
rho <- perb(mail)
prop2prob(rho)
}
\seealso{
\code{\link{propr}}, \code{\link{abstract}}
}

