% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelPlots.R
\name{feature_plot}
\alias{feature_plot}
\title{Visualize feature (protein) variation among conditions}
\usage{
feature_plot(
  model_df,
  type = "box",
  text_size = 10,
  palette = "viridis",
  n_row,
  n_col,
  save = FALSE,
  file_path = NULL,
  file_name = "Feature_plot",
  file_type = "pdf",
  dpi = 80,
  plot_width = 7,
  plot_height = 7
)
}
\arguments{
\item{model_df}{A \code{model_df} object from performing \code{pre_process}.}

\item{type}{Type of plot to generate. Choices are "box" or "density." Default
is \code{"box."}}

\item{text_size}{Text size for plot labels, axis labels etc. Default is
\code{10}.}

\item{palette}{Viridis color palette option for plots. Default is
\code{"viridis"}. See
\code{\link[viridisLite:viridis]{viridis}}
for available options.}

\item{n_row}{Number of rows to print the plots.}

\item{n_col}{Number of columns to print the plots.}

\item{save}{Logical. If \code{TRUE} saves a copy of the plot in the
directory provided in \code{file_path}.}

\item{file_path}{A string containing the directory path to save the file.}

\item{file_name}{File name to save the plot.
Default is \code{"Feature_plot."}}

\item{file_type}{File type to save the plot.
Default is \code{"pdf"}.}

\item{dpi}{Plot resolution. Default is \code{80}.}

\item{plot_width}{Width of the plot. Default is \code{7}.}

\item{plot_height}{Height of the plot. Default is \code{7}.}
}
\value{
A \code{ggplot2} object
}
\description{
This function visualizes protein intensity differences among
conditions (classes) using box plots or density distribution plots.
}
\details{
This function visualizes condition-wise differences in protein
intensity using boxplots and/or density plots.
}
\examples{

## Create a model_df object with default settings.
covid_model_df <- pre_process(covid_fit_df, covid_norm_df)

## Feature variation - box plots
feature_plot(covid_model_df, type = "box", n_row = 4, n_col = 2)

## Density plots
feature_plot(covid_model_df, type = "density")

## Change color palette
feature_plot(covid_model_df, type = "density", n_row = 4, n_col = 2, palette = "rocket")

}
\seealso{
\itemize{
\item \code{pre_process}, \code{rem_feature}}
}
\author{
Chathurani Ranathunge
}
