% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promise.R
\name{promise}
\alias{promise}
\title{Create a new promise object}
\usage{
promise(action)
}
\arguments{
\item{action}{A function with signature \code{function(resolve, reject)}, or a
one-sided formula. See Details.}
}
\value{
A promise object (see \code{\link{then}}).
}
\description{
\code{promise()} creates a new promise. A promise is a placeholder object for the
eventual result (or error) of an asynchronous operation. This function is not
generally needed to carry out asynchronous programming tasks; instead, it is
intended to be used mostly by package authors who want to write asynchronous
functions that return promises.
}
\details{
The \code{action} function should be a piece of code that returns quickly, but
initiates a potentially long-running, asynchronous task. If/when the task
successfully completes, call \code{resolve(value)} where \code{value} is the result of
the computation (like the return value). If the task fails, call
\code{reject(reason)}, where \code{reason} is either an error object, or a character
string.

It's important that asynchronous tasks kicked off from \code{action} be coded very
carefully--in particular, all errors must be caught and passed to \code{reject()}.
Failure to do so will cause those errors to be lost, at best; and the caller
of the asynchronous task will never receive a response (the asynchronous
equivalent of a function call that never returns, i.e. hangs).

The return value of \code{action} will be ignored.
}
\examples{
# Create a promise that resolves to a random value after 2 secs
p1 <- promise(function(resolve, reject) {
  later::later(~resolve(runif(1)), delay = 2)
})

p1 \%...>\% print()

# Create a promise that errors immediately
p2 <- promise(~{
  reject("An error has occurred")
})
then(p2,
  onFulfilled = ~message("Success"),
  onRejected = ~message("Failure")
)

}
