% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reproducibility.R
\name{save_session_info}
\alias{save_session_info}
\title{Save R session information}
\usage{
save_session_info(path_dir = here::here("progs", "session_info"))
}
\arguments{
\item{path_dir}{The full path of the directory where the session information
text file shall be written. If it doesn't exist, it is written with
\code{fs::\link[fs]{dir_create}()}.}
}
\value{
A list of two:

  \code{$ time           :} the value of \code{\link{Sys.time}()} that the
  function used

  \code{$ session_info() :} the value of
  \code{sessioninfo::\link[sessioninfo]{session_info}()} that the function
  used
}
\description{
Creates a dated text file (.txt) containing the contents of
\code{sessioninfo::\link[sessioninfo]{session_info}()}.
}
\details{
The date and time when this function was run is included in the resulting
.txt file's name and first line. This date and time is obtained from
\code{\link{Sys.time}()}.

For the file name, hyphens (-) are removed from the date, spaces are replaced
with underscores (_), and colons (:) are replaced with a modifier letter
colon (U+A789).
}
