% Generated by roxygen2 (4.1.0.9001): do not edit by hand
% Please edit documentation in R/plot.pickapoint.R
\name{plot.pickapoint}
\alias{plot.pickapoint}
\title{Plot Function For Pick-a-Point}
\usage{
\method{plot}{pickapoint}(x, xlab = "", ylab = "", xlim = 0, ylim = 0,
  axlwd = 10, cesize = 1.2, cilwd = 5, \dots)
}
\arguments{
\item{x}{An object of class \code{"pickapoint"}.}

\item{xlab}{A title for the x axis (character).}

\item{ylab}{A title for the y axis (character).}

\item{xlim}{Coordinates range for x axis (numeric vector). Determined by the range of the given data by default.}

\item{ylim}{Coordinates range for y axis (numeric vector). Determined by the range of the given data by default.}

\item{axlwd}{Axis line width (numeric vector). \code{axlwd=10} by default.}

\item{cesize}{Size of the conditional effect marker (numeric vector). \code{cesize=1.2} by default.}

\item{cilwd}{Conditional interval line width (numeric vector). \code{cilwd=5} by default.}

\item{\dots}{Additional arguments (not supported yet).}
}
\value{
none
}
\description{
Plot function for objects of class \code{"pickapoint"}.
}
\examples{
\dontrun{
myModel <- lm('DV ~ IV + MOD', data=someData)
papresults <- pickapoint(myModel, dv='DV', iv='IV', mod='MOD')
plot(papresults)
}
}

