% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differences.R
\name{prec_rateratio}
\alias{prec_rateratio}
\title{Sample size or precision for a rate ratio}
\usage{
prec_rateratio(
  n1 = NULL,
  rate1 = NULL,
  rate2 = 2 * rate1,
  prec.level = NULL,
  r = 1,
  conf.level = 0.95
)
}
\arguments{
\item{n1}{number of patients in exposed group.}

\item{rate1}{event rate in the exposed group.}

\item{rate2}{event rate in the unexposed group.}

\item{prec.level}{ratio of the upper limit over the lower limit of the
rate ratio confidence interval.}

\item{r}{allocation ratio (relative size of unexposed and exposed cohort
(\code{n2} / \code{n1})).}

\item{conf.level}{confidence level.}
}
\description{
\code{prec_rateratio} returns the sample size or the precision for the
provided proportions.
}
\details{
Exactly one of the parameters  \code{n1} or \code{conf.width} must be passed as
NULL, and that parameter is determined from the other. Event rates in the two
groups should also be provided (\code{rate1, rate2}). If only
\code{rate1} is provided, \code{rate2} is assumed to be 2 times
\code{rate1}.
}
\examples{
prec_rateratio(20, .5, 3)
prec_rateratio(rate1 = .5, rate2 = 3, prec.level = 3.81)
}
\references{
Rothman KJ, Greenland S (2018). \emph{Planning Study Size Based on
  Precision Rather Than Power}. Epidemiology, 29:599-603.
  \href{https://doi.org/10.1097/EDE.0000000000000876}{doi:10.1097/EDE.0000000000000876}.
}
