% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive_stats.R
\name{prec_prop}
\alias{prec_prop}
\title{Sample size or precision for a proportion}
\usage{
prec_prop(
  p,
  n = NULL,
  conf.width = NULL,
  conf.level = 0.95,
  method = c("wilson", "agresti-coull", "exact", "wald"),
  ...
)
}
\arguments{
\item{p}{proportion.}

\item{n}{number of observations.}

\item{conf.width}{precision (the full width of the confidence interval).}

\item{conf.level}{confidence level.}

\item{method}{The method to use to calculate precision. Exactly one method
may be provided. Methods can be abbreviated.}

\item{...}{other arguments to uniroot (e.g. \code{tol}).}
}
\value{
Object of class "presize", a list of arguments (including the
  computed one) augmented with method and note elements. In the wilson and
  agresti-coull formula, the p from which the confidence interval is
  calculated is adjusted by a term (i.e. \eqn{p + term \pm ci}). This
  adjusted p is returned in \code{padj}.
}
\description{
\code{prec_prop} returns the sample size or the precision for the provided
proportion.
}
\details{
Exactly one of the parameters \code{n} or \code{conf.width} must be passed as NULL,
and that parameter is determined from the other.

The wilson, agresti-coull, exact, and wald method are implemented. The
wilson method is suggested for small \code{n} (< 40), and the agresti-coull method
is suggested for larger \code{n} (see reference). The wald method is not suggested,
but provided due to its widely distributed use.

\code{\link[stats]{uniroot}} is used to solve \code{n} for the agresti-coull,
wilson, and exact methods. Agresti-coull can be abbreviated by ac.
}
\examples{
prec_prop(p = 1:9 / 10, n = 100, method = "wilson")
prec_prop(p = 1:9 / 10, conf.width = .192, method = "wilson")
}
\references{
Brown LD, Cai TT, DasGupta A (2001) \emph{Interval Estimation for
  a Binomial Proportion}, Statistical Science, 16:2, 101-117,
  \href{https://doi.org/10.1214/ss/1009213286}{doi:10.1214/ss/1009213286}
}
\seealso{
\code{\link[stats]{binom.test}}, \code{\link[binom]{binom.confint}}
  in package \pkg{binom}, and \code{\link[Hmisc]{binconf}} in package
  \pkg{Hmisc}
}
