% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptive_stats.R
\name{prec_mean}
\alias{prec_mean}
\title{Sample size or precision for a mean}
\usage{
prec_mean(mu, sd, n = NULL, conf.width = NULL, conf.level = 0.95, ...)
}
\arguments{
\item{mu}{mean.}

\item{sd}{standard deviation.}

\item{n}{number of observations.}

\item{conf.width}{precision (the full width of the confidence interval).}

\item{conf.level}{confidence level.}

\item{...}{other arguments to uniroot (e.g. \code{tol}).}
}
\value{
Object of class "presize", a list with \code{mu} mean, \code{sd} standard deviation, \code{n} sample size, 
\code{conf.width} precision (the width of the conficence interval), 
\code{lwr} lower bound of confidence interval, \code{upr} upper bound of confidence interval,
 augmented with method and note elements.
}
\description{
\code{prec_mean} returns the sample size or the precision for the provided
mean and standard deviation.
}
\details{
Exactly one of the parameters \code{n} or \code{conf.width} must be passed as NULL,
and that parameter is determined from the other.

The precision is defined as the full width of the confidence interval. The
confidence interval calculated as \eqn{t(n - 1) * sd / sqrt(n)}, with t(n-1)
from the t-distribution with n-1 degrees of freedom.

\code{\link[stats]{uniroot}} is used to solve \code{n}.
}
\examples{
prec_mean(mu = 5, sd = 2.5, n = 20)
prec_mean(mu = 5, sd = 2.5, conf.width = 2.34)  # approximately the inverse of above
}
