% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grammar.R
\name{person}
\alias{person}
\alias{set_person}
\alias{get_person}
\title{Set or get the \code{pregnancy.person} option for pregnancy-related messages}
\usage{
set_person(person)

get_person()
}
\arguments{
\item{person}{The person who is pregnant, to determine the grammar for the output message. Can be:
\itemize{
\item "I", "1", "1st", "first", or numeric \code{1} for first person
\item "you", "2", "2nd", "second", or numeric \code{2} for second person
\item Any other name for third person
\item \code{NULL}: will try to use the "pregnancy.person" option. Defaults to "You" if the option is set.
}}
}
\value{
Both functions invisibly return the current person setting:
\itemize{
\item get_person() returns the current setting (a character string) or NULL if not set
\item set_person() returns the person value that was set
}
}
\description{
Functions to get and set the default person used in messages throughout the package.
This affects the grammar and pronouns used in various function outputs. Settings
persist for the current R session only, unless added to .Rprofile. \code{set_person()} sets the "pregnancy.person" option and \code{get_person()} retrieves it.
}
\examples{
# Store original setting (without messages)
original_person <- getOption("pregnancy.person")

# Check current setting
get_person()

# Set to first person (using string)
set_person("I")
get_person()

# Set to second person (using number)
set_person(2)
get_person()

# Set to a specific name
set_person("Sarah")
get_person()

# Restore original setting (without messages)
options(pregnancy.person = original_person)

}
\seealso{
\code{\link[=how_far]{how_far()}} and other functions that use the person setting for message formatting
}
