% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{qb_dat1}
\alias{qb_dat1}
\title{Quasi-binomial data (example 1)}
\format{
A \code{data.frame} with 3 rows and 2 columns:
\describe{
  \item{succ}{numbers of success}
  \item{fail}{numbers of failures}
}
}
\usage{
qb_dat1
}
\description{
This data set contains sampled quasi-binomial data from from 10 clusters
each of size 50. The data set was sampled with \code{rqbinom(n=10, size=50, prob=0.1, phi=3)}.
}
\examples{
# Upper prediction limit for m=3 future observations
# that are based on cluster sizes 40, 50, 60 respectively
quasi_bin_pi(histdat=qb_dat1, newsize=c(40, 50, 60), alternative="upper", nboot=100)

# Please note that nboot was set to 100 in order to decrease computing time
# of the example. For a valid analysis set nboot=10000.

}
\keyword{datasets}
