% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRange.R
\name{getRange}
\alias{getRange}
\title{Determine the Width and Height of a Plot}
\usage{
getRange(region, units)
}
\arguments{
\item{region}{The region of the plot to use for defining the boundaries. Must
be one of "device", "figure", "plot", or "data".}

\item{units}{Character string giving the units in which to define the range.
Must be one of "in", "px", "data", or "lines".}
}
\value{
Numeric vector of length two giving the range of the plotting
        region, in the order of x-axis, y-axis.
}
\description{
Determine the Width and Height of a Plot
}
\examples{
\dontrun{

plot(1:10)
print(getRange('data', 'in'))
print(getRange('plot', 'px'))
print(getRange('figure', 'data'))
print(getRange('device', 'lines'))

}

}
\author{
Jasper Watson
}
