% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crm.R
\name{crm}
\alias{crm}
\title{A package-local (as-yet, unexported) test harness adapted from \code{dfcrm::crm()}.}
\usage{
crm(
  prior,
  target,
  tox,
  level,
  n = length(level),
  dosename = NULL,
  include = 1:n,
  pid = 1:n,
  conf.level = 0.9,
  method = "bayes",
  model = "empiric",
  intcpt = 3,
  scale = sqrt(1.34),
  model.detail = TRUE,
  patient.detail = TRUE,
  var.est = TRUE,
  impl = c("rusti", "ruste", "dfcrm")
)
}
\arguments{
\item{prior}{The CRM skeleton: dose-wise prior probabilities of toxicity}

\item{target}{Target toxicity rate}

\item{tox}{A patient-wise vector of toxicity counts}

\item{level}{A patient-wise vector of dose level assignments}

\item{n}{The number of patients enrolled}

\item{dosename}{Optional designators for the doses}

\item{include}{Index of patients to include}

\item{pid}{Vector of patient ID labels}

\item{conf.level}{Used to assign upper and lower bounds on predicted probability
of toxicity, which in turn may be referenced in escalation, deescalation and
stopping decisions.}

\item{method}{Estimation method:}

\item{model}{Presently, only the \sQuote{empiric} (or \sQuote{power}) model
has a Rust likelihood implementation.}

\item{intcpt}{Intercept for \sQuote{logistic} model}

\item{scale}{Sigma parameter of prior on beta parameter}

\item{model.detail}{If FALSE, the model content of an \code{mtd} object will not
be displayed.  Default is TRUE.}

\item{patient.detail}{If FALSE, patient summary of an \code{mtd} object will not
be displayed.  Default is TRUE.}

\item{var.est}{If TRUE, variance of the estimate of the model parameter and
probability/confidence interval for the dose-toxicity curve will be computed}

\item{impl}{Switch between \code{'rusti'} and \code{'dfcrm'} implementations.
Currently the \code{'rusti'} option is implemented only for the Bayes method
of the empirical (\sQuote{power}) model. An experimental \code{'ruste'}
implementation is in the works.}
}
\description{
for various performance tuning experiments. The \code{impl} arg allows selection
of various alternative implementations:
\itemize{
\item \code{'rusti'} substitutes integrands \code{crmh}, \code{crmht}, \code{crmht2} written in Rust
\item \code{'dfcrm'} is the original as implemented in package \code{dfcrm}.
}
}
\author{
Adapted by David C. Norris, from Ken Cheung's \CRANpkg{dfcrm}
}
