% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiKEN2011}
\alias{ppiKEN2011}
\title{Poverty Probability Index (PPI) lookup table for Kenya}
\format{A data frame with 11 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nlFood}}{Food poverty line}
\item{\code{nl100}}{National poverty line (100\%)}
\item{\code{nl150}}{National poverty line (150\%)}
\item{\code{extreme}}{USAID extreme poverty}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
\item{\code{ppp400}}{Below $4.00 per day purchasing power parity (2005)}
\item{\code{ppp844}}{Below $8.44 per day purchasing power parity (2005)}
\item{\code{ppp190}}{Below $1.90 per day purchasing power parity (2011)}
\item{\code{ppp310}}{Below $3.10 per day purchasing power parity (2011)}
}}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiKEN2011
}
\description{
Poverty Probability Index (PPI) lookup table for Kenya
}
\examples{
  # Access Kenya PPI table
  ppiKEN2011

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiKEN2011[ppiKEN2011$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiKEN2011, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the USAID
  # extreme poverty definition
  ppiScore <- 50
  ppiKEN2011[ppiKEN2011$score == ppiScore, "extreme"]

}
\keyword{datasets}
