% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppgmConsensus.R
\name{ppgmConsensus}
\alias{ppgmConsensus}
\title{ppgmConsensus}
\usage{
ppgmConsensus(occurrences, fossils = FALSE, trees, 
fossils.edges = FALSE, model = "BM", permut = 1, only.biovars = TRUE, 
which.biovars = c(1:19), path = "", plot.TraitGram = FALSE, 
plot.AnimatedMaps = FALSE, plot.GeoRates = FALSE, bounds = list(), 
control = list(), use.paleoclimate = TRUE, paleoclimateUser = NULL, 
layerAge = c(0:20), verbose = TRUE)
}
\arguments{
\item{occurrences}{a matrix with three columns of species name, longitude, and latitude, in that order, and rows that are entries for species occurrences. The bioclimate variables can be included for each occurrence in following columns. They must be in order 1 through 19.}

\item{fossils}{a matrix with four columns of min age, max age, longitude, and latitude, in that order, and rows that are entries for fossil occurrences. The bioclimate variables can be included for each occurrence in following columns. They must be in order 1 through 19. All 19 variables must be included at this stage, variable selection is done with the argument: "which.biovars".}

\item{trees}{phylogeny of species from first column of occurrences argument. Object of class phylo.}

\item{fossils.edges}{a vector of edges that the fossils belong to. Must be in the same order of the fossils argument. If fossils.edges is false, the the function randomly assigns the location of the fossils depending on the age (see details for more information).}

\item{model}{the model of evolution to use to estimate ancestor nodes. Argument is passed onto to function nodeEstimate.}

\item{permut}{the number of times to randomly place fossils in phylogeny and estimate ancestor states.}

\item{only.biovars}{logical. If FALSE, user must include biovariables in occurrence object.}

\item{which.biovars}{a vector with the biovars to include in model (see www.worldclim.org for a list of biovars). If "ALL", then all 19 biovars are included in analysis.}

\item{path}{path to the directory where the results should be saved.}

\item{plot.TraitGram}{logical. Whether to plot a TraitGram}

\item{plot.AnimatedMaps}{Logical. Whether to plot AnimatedMaps. Requires ImageMagick to be installed on the system.}

\item{plot.GeoRates}{logical. Whether to plot GeoRates}

\item{bounds}{parameters for the evolutionary model selected. If none are supplied the default is used}

\item{control}{settings used for optimisation of model likelihood. Passes to \code{geiger::fitContinuous}}

\item{use.paleoclimate}{if left blank, default North America paleoclimate data is used. If FALSE, user submitted paleoclimate must be provided}

\item{paleoclimateUser}{list of data frames with paleoclimates, must be dataframes with columns: GlobalID, Longitude, Latitude, bio1, bio2,...,bio19.}

\item{layerAge}{vector with the ages of the paleoclimate dataframes, if using user submitted paleoclimate data}

\item{verbose}{default true, returns all outputs. If FALSE then returns only climate envelopes and geographic data}
}
\value{
\code{cem} Estimate of climate envelope for each species in present time. A data frame containing species and min mean and max of biovars specified with \code{which.biovars}.

\code{geo_move} data frame of RateGeoCenter and RateGeoSize

\code{change_geo_center} array of change in geographic center of suitable climate for each lineage

\code{change_geo_size} array of change in geographic size of suitable climate for each lineage

\code{time_int} matrix array of time intervals

\code{treedata_min} list of trees with minimum bioclimatic variables

\code{treedata_max} list of trees with maximum bioclimatic variables

\code{node_est} list of traits at each node for all trees, min and max for each species. As estimated by nodeEstimate and nodeEstimateEnvelopes

\code{aicmin} if model is estimated, table of aic values for minimum trait values

\code{aicmax} if model is estimated, table of aic values for maximum trait values
}
\description{
ppgm makes a paleophylogeographic species distribution model using the bioclimate envelope method for a specified time period. consensus version
}
\details{
If the 19 bioclimate variables are not supplied with the occurrences or with the fossils, they will be extracted from the closest 50km point location in the modern or paleoclimate maps that are loaded in with this function. The paleoclimate maps are isotopically scaled between general circulation models (see Lawing and Polly 2011; Rodder et al. 2013) and modern climate (see Hijmans et al. 2005). The fossils paleoclimate data is extracted to the closest million year paleoclimate map. Paleoclimate maps are derived at one million year intervals for the past 20 Ma. The tree (phylogeny) should be dichotomous and the species names should match the names in the first column of the occurrences argument.
}
\examples{
data(sampletrees)
data(occurrences)
data(scel_fossils)
bounds <- list(sigsq = c(min = 0, max = 1000000))
ex_mytree <- sampletrees[[3]] #single tree
\donttest{test_fossil_con <- ppgmConsensus(occurrences = occurrences, 
fossils = scel_fossils, trees = ex_mytree, fossils.edges = FALSE, model = "BM", 
permut = 5, which.biovars = 1, bounds = bounds, control = list(niter = 20))}
}
\author{
A. Michelle Lawing, Alexandra F. C. Howard, Maria A. Hurtado-Materon
}
