% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrub_mail.R
\name{scrub_mail}
\alias{scrub_mail}
\title{Clean the response from fetched mail}
\usage{
scrub_mail(tbl)
}
\arguments{
\item{tbl}{A tibble; the result of a call to \code{\link{fetch_mail}}.}
}
\value{
A tibble with the same number of rows the input. \code{delivery_day} becomes \code{delivery_date} and \code{delivery_by_time}, from which \code{delivery_duration} in days is calculated (\code{delivery_date - shipping_date}).
}
\description{
Clean the response from fetched mail
}
\details{
This scrubber converts "Not available"s to \code{NA}s, removes dollar signs from prices and converts them to numeric, and splits \code{delivery_day} into YYYY-MM-DD \code{delivery_date} and \code{delivery_by_time} (if present, the time of day by which the mail should arrive).

\code{delivery_date} is inferred from the current year.
}
\examples{
\dontrun{

fetch_mail_flat_rate(origin_zip = "60647",
         destination_zip = "11238", type = "envelope") \%>\% scrub_mail()
}

}
