% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{garamba}
\alias{garamba}
\title{African mammals survey in the Garamba National Park}
\format{
A \code{data.frame} with 141 rows (counts) and the following 8 variables:
\describe{
\item{location}{the location of the survey (Garamba)}
\item{species}{the binomial name of the species}
\item{date}{the date of the survey}
\item{stat_method}{the method used to estimate individuals counts. One of
\code{T} (total counts), \code{G} (guesstimate), and \code{S}
(sampling counts)}
\item{field_method}{the field method used to collect data. One of
\code{A} (aerial counts), and \code{G} (ground counts)}
\item{count}{number of individuals}
\item{lower_ci}{lower boundary of the 95\% confidence interval of the counts
(only for sampling counts)}
\item{upper_ci}{upper boundary of the 95\% confidence interval of the counts
(only for sampling counts)}
\item{pref_field_method}{the preferred field method of the species. One of
\code{A} for Aerial counts, and \code{G} for Ground counts}
\item{conversion_A2G}{the conversion multiplicative factor (corresponding
to the detectability category) used to convert aerial to ground counts}
\item{rmax}{the maximum population growth rate}
}
}
\usage{
garamba
}
\description{
This dataset contains individual counts of 10 African mammal species
in the Garamba National Park (Democratic Republic of the Congo) from 1976 to
2017.
}
\examples{
data("garamba")
head(garamba, 30)
}
\references{
Hillman Smith K & Kalpers J (2015) \emph{Garamba Conservation in Peace & War}.
Hillman Smith publisher, 448pp. ISBN: 9789966185105.\cr
Monico M (2014)
\emph{Aerial Survey Report March 2014 - Garamba National Park, DRC}.
African Parks Network/ICCN/Pan-African Elephant Aerial Survey, 42pp.\cr
Spies K \emph{et al.} (2017)
\emph{Aerial Survey Report April 2017 - Garamba National Park, DRC}.
African Parks Network/EU/ICCN. 38pp.
}
\keyword{datasets}
