% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_gdfa.R
\name{plot_gdfa}
\alias{plot_gdfa}
\title{Plot Log-OR vs. X for Gamma Discriminant Function Approach}
\usage{
plot_gdfa(estimates, varcov = NULL, xrange, xname = "X",
  cvals = NULL, set_labels = NULL, set_panels = TRUE, ncol = 1)
}
\arguments{
\item{estimates}{Numeric vector of point estimates for
\code{(gamma_0, gamma_y, gamma_c^T, b1, b0)}.}

\item{varcov}{Numeric matrix with variance-covariance matrix for
\code{estimates}. If \code{NULL}, 95\% confidence bands are omitted.}

\item{xrange}{Numeric vector specifying range of X values to plot.}

\item{xname}{Character vector specifying name of X variable, for
plot title and x-axis label.}

\item{cvals}{Numeric vector or list of numeric vectors specifying covariate
values to use in log-odds ratio calculations.}

\item{set_labels}{Character vector of labels for the sets of covariate
values. Only used if \code{cvals} is a list.}

\item{set_panels}{Logical value for whether to use separate panels for each
set of covariate values, as opposed to using different colors on a single
plot.}

\item{ncol}{Integer value specifying number of columns for multi-panel
figure. Only used if there are multiple sets of covariate values (i.e.
\code{cvals} is a list).}
}
\value{
Plot of log-OR vs. X generated by \code{\link[ggplot2]{ggplot}}.
}
\description{
When \code{\link{p_gdfa}} is fit with \code{constant_or = FALSE}, the
log-OR for X depends on the value of X (and covariates, if any). This
function plots the log-OR vs. X for one or several sets of covariate values.
}
\examples{
# Fit Gamma discriminant function model for poolwise X vs. (Y, C), without
# assuming a constant log-OR. Note that data were generated with a constant
# log-OR of 0.5.
data(dat_p_gdfa)
dat <- dat_p_gdfa$dat
c.list <- dat_p_gdfa$c.list
fit <- p_gdfa(
  g = dat$g,
  y = dat$y,
  xtilde = dat$x,
  c = c.list,
  errors = "neither",
  constant_or = FALSE
)

# Plot estimated log-OR vs. X, holding C fixed at the sample mean.
p <- plot_gdfa(
  estimates = fit$estimates,
  varcov = fit$theta.var,
  xrange = range(dat$x[dat$g == 1]),
  cvals = mean(unlist(c.list))
)
p


}
