% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/p_dfa_xerrors2.R
\name{p_dfa_xerrors2}
\alias{p_dfa_xerrors2}
\title{Discriminant Function Approach for Estimating Odds Ratio with Gamma Exposure
Measured in Pools and Potentially Subject to Errors}
\usage{
p_dfa_xerrors2(g, y, xtilde, c = NULL, constant_or = TRUE,
  errors = "both", integrate_tol = 1e-08,
  integrate_tol_hessian = integrate_tol, estimate_var = TRUE,
  fix_posdef = FALSE, ...)
}
\arguments{
\item{g}{Numeric vector with pool sizes, i.e. number of members in each pool.}

\item{y}{Numeric vector with poolwise \code{Y} values, coded 0 if all members
are controls and 1 if all members are cases.}

\item{xtilde}{Numeric vector (or list of numeric vectors, if some pools have
replicates) with \code{Xtilde} values.}

\item{c}{List where each element is a numeric matrix containing the
\strong{\code{C}} values for members of a particular pool (1 row for each
member).}

\item{constant_or}{Logical value for whether to assume a constant OR for
\code{X}, which means that \code{gamma_y = 0}. If \code{NULL}, model is
fit with and without this assumption, and likelihood ratio test is performed
to test it.}

\item{errors}{Character string specifying the errors that \code{X} is subject
to. Choices are \code{"neither"}, \code{"processing"} for processing error
only, \code{"measurement"} for measurement error only, and \code{"both"}.}

\item{integrate_tol}{Numeric value specifying the \code{tol} input to
\code{\link{hcubature}}.}

\item{integrate_tol_hessian}{Same as \code{integrate_tol}, but for use when
estimating the Hessian matrix only. Sometimes more precise integration
(i.e. smaller tolerance) helps prevent cases where the inverse Hessian is not
positive definite.}

\item{estimate_var}{Logical value for whether to return variance-covariance
matrix for parameter estimates.}

\item{fix_posdef}{Logical value for whether to repeatedly reduce
\code{integrate_tol_hessian} by factor of 5 and re-estimate Hessian to try
to avoid non-positive definite variance-covariance matrix.}

\item{...}{Additional arguments to pass to \code{\link[stats]{nlminb}}.}
}
\value{
List of point estimates, variance-covariance matrix, objects returned by
\code{\link[stats]{nlminb}}, and AICs, for one or two models depending on
\code{constant_or}. If \code{constant_or = NULL}, also returns result of a
likelihood ratio test for \code{H0: gamma_y = 0}, which is equivalent to
\code{H0: log-OR is constant}. If \code{constant_or = NULL}, returned objects
with names ending in 1 are for model that does not assume constant log-OR,
and those ending in 2 are for model that assumes constant log-OR.
}
\description{
Archived on 7/23/18. Please use \code{\link{p_gdfa}} instead.
}
\examples{
# Load dataset with (g, Y, Xtilde, C) values for 248 pools and list of C
# values for members of each pool. Xtilde values are affected by processing
# error.
data(pdat2)
dat <- pdat2$dat
c.list <- pdat2$c.list

# Estimate log-OR for X and Y adjusted for C, ignoring processing error
fit1 <- p_dfa_xerrors2(
  g = dat$g,
  y = dat$y,
  xtilde = dat$xtilde,
  c = c.list,
  errors = "neither"
)
fit1$estimates

# Repeat, but accounting for processing error.
\dontrun{
fit2 <- p_dfa_xerrors2(
  g = dat$g,
  y = dat$y,
  xtilde = dat$xtilde,
  c = c.list,
  errors = "processing",
  control = list(trace = 1)
)
fit2$estimates
}

}
\references{
Lyles, R.H., Van Domelen, D.R., Mitchell, E.M. and Schisterman, E.F. (2015)
"A discriminant function approach to adjust for processing and measurement
error When a biomarker is assayed in pooled samples."
\emph{Int. J. Environ. Res. Public Health} \strong{12}(11): 14723--14740.

Mitchell, E.M, Lyles, R.H., and Schisterman, E.F. (2015) "Positing, fitting,
and selecting regression models for pooled biomarker data." \emph{Stat. Med}
\strong{34}(17): 2544--2558.

Schisterman, E.F., Vexler, A., Mumford, S.L. and Perkins, N.J. (2010) "Hybrid
pooled-unpooled design for cost-efficient measurement of biomarkers."
\emph{Stat. Med.} \strong{29}(5): 597--613.

Whitcomb, B.W., Perkins, N.J., Zhang, Z., Ye, A., and Lyles, R. H. (2012)
"Assessment of skewed exposure in case-control studies with pooling."
\emph{Stat. Med.} \strong{31}: 2461--2472.
}
