% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{statsContig}
\alias{statsContig}
\title{Compute summary statistics from observed data}
\usage{
statsContig(randomWindows, nPops, stat.names = NA)
}
\arguments{
\item{randomWindows}{a list with randomly selected loci of observed data.
This list should contain five elements: \code{freqs}, \code{positions}, \code{rMajor},
\code{rMinor} and \code{coverage}. Each of those elements should contain one entry
per locus with the appropriate information.}

\item{nPops}{is an integer indicating how many different populations are
present in the dataset you are analysing.}

\item{stat.names}{optional character vector with the names of the summary
statistics from the simulated data. If available, these names will be added
to the summary statistics computed from the observed data.}
}
\value{
a vector of observed summary statistics. These summary statistics are
computed from blocks of observed data present in the \code{randomWindows} input
argument. If the \code{stat.names} input argument is available, the summary
statistics will be named.
}
\description{
Computes a defined set of summary statistics from observed data. Those
summary statistics can then be used as the target for parameter estimation or
model selection with Approximate Bayesian Computation.
}
\details{
Summary statistics are computed for a given subset of the data. Ideally, this
subset is composed of randomly selected windows of the observed data. Those
random windows should be selected from multiple contigs, treating each contig
as a different locus.
}
\keyword{internal}
