% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBI-custom.R
\name{DBI-custom}
\alias{DBI-custom}
\alias{dbSendQuery,Pool-method}
\alias{dbSendStatement,Pool,ANY-method}
\alias{dbDisconnect,Pool-method}
\alias{dbGetInfo,Pool-method}
\alias{dbIsValid,Pool-method}
\alias{dbBegin,Pool-method}
\alias{dbCommit,Pool-method}
\alias{dbRollback,Pool-method}
\alias{dbWithTransaction,Pool-method}
\title{Unsupported DBI methods}
\usage{
\S4method{dbSendQuery}{Pool}(conn, statement, ...)

\S4method{dbSendStatement}{Pool,ANY}(conn, statement, ...)

\S4method{dbDisconnect}{Pool}(conn, ...)

\S4method{dbGetInfo}{Pool}(dbObj, ...)

\S4method{dbIsValid}{Pool}(dbObj, ...)

\S4method{dbBegin}{Pool}(conn, ...)

\S4method{dbCommit}{Pool}(conn, ...)

\S4method{dbRollback}{Pool}(conn, ...)

\S4method{dbWithTransaction}{Pool}(conn, code)
}
\arguments{
\item{conn, dbObj}{A Pool object, as returned from \code{\link[=dbPool]{dbPool()}}.}

\item{statement, code, ...}{See DBI documentation.}
}
\description{
Most pool methods for DBI generics check out a connection, perform the
operation, and the return the connection to the pool, as described in
\link{DBI-wrap}.

This page describes the exceptions:
\itemize{
\item \code{\link[DBI:dbSendQuery]{DBI::dbSendQuery()}} and \code{\link[DBI:dbSendStatement]{DBI::dbSendStatement()}} can't work with pool
because they return result sets that are bound to a specific connection.
Instead use \code{\link[DBI:dbGetQuery]{DBI::dbGetQuery()}}, \code{\link[DBI:dbExecute]{DBI::dbExecute()}}, or
\code{\link[=localCheckout]{localCheckout()}}.
\item \code{\link[DBI:transactions]{DBI::dbBegin()}}, \code{\link[DBI:transactions]{DBI::dbRollback()}}, \code{\link[DBI:transactions]{DBI::dbCommit()}}, and
\code{\link[DBI:dbWithTransaction]{DBI::dbWithTransaction()}} can't work with pool because transactions are
bound to a connection. Instead use \code{\link[=poolWithTransaction]{poolWithTransaction()}}.
\item \code{\link[DBI:dbDisconnect]{DBI::dbDisconnect()}} can't work because pool handles disconnection.
\item \code{\link[DBI:dbGetInfo]{DBI::dbGetInfo()}} returns information about the pool, not the database
connection.
\item \code{\link[DBI:dbIsValid]{DBI::dbIsValid()}} returns whether or not the entire pool is valid (i.e.
not closed).
}
}
