% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{write.TSNPM}
\alias{write.TSNPM}
\title{Write TetraploidSNPMap input file}
\usage{
write.TSNPM(phased.maplist, outputdir = "TetraploidSNPMap_QTLfiles",
  filename = "TSNPM", ploidy, verbose = FALSE)
}
\arguments{
\item{phased.maplist}{Phased maps in list format, the output of \code{\link{create_phased_maplist}}}

\item{outputdir}{Directory to which TetraploidSNPMap files are written, by default written to "TetraploidSNPMap_QTL" folder}

\item{filename}{Character string of filename stem to write the output files to, by default "TSNPM" with linkage groups names appended}

\item{ploidy}{The ploidy of the species, currently only 4 is supported by TetraploidSNPMap}

\item{verbose}{Should messages be send to stdout?}
}
\value{
\code{NULL}
}
\description{
Output the phased linkage map files into format readable by TetraploidSNPMap (Hackett et al. 2017) to perform QTL analysis.
}
\examples{
data("phased.maplist")
write.TSNPM(phased.maplist,ploidy=4)
}
