% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrateOverPolyhedron.R
\name{integrateOverPolyhedron}
\alias{integrateOverPolyhedron}
\title{Multiple integral over a polyhedron}
\usage{
integrateOverPolyhedron(f, A, b)
}
\arguments{
\item{f}{either a function, a \strong{spray} polynomial, or a
\strong{qspray} polynomial; its number of variables must match the
number of columns of the matrix \code{A}}

\item{A, b}{matrix and vector defining the linear inequalities which must be
in numeric mode or, for exactness, in character mode, with an integer or
a fraction as each entry; if \code{f} is a \strong{qspray} polynomial,
then \code{A} and \code{b} will be converted to character mode if they
are in numeric mode, with the function \code{\link[rcdd]{d2q}}}
}
\value{
There are three possible values: an output of
  \code{\link[SimplicialCubature]{adaptIntegrateSimplex}} if
  \code{f} is a function, an output of
  \code{\link[SimplicialCubature]{integrateSimplexPolynomial}} if
  \code{f} is a \strong{spray} polynomial, or a character representing
  the value of the integral as a fraction if
  \code{f} is a \strong{qspray} polynomial.
}
\description{
Multiple integral over a convex polyhedron given by a set of
  linear inequalities. See the vignette for explanations and examples.
}
\examples{
A <- rbind(
  c(-1, 0, 0), # -x
  c( 1, 0, 0), # x
  c( 0,-1, 0), # -y
  c( 1, 1, 0), # x+y
  c( 0, 0,-1), # -z
  c( 1, 1, 1)  # x+y+z
)
b <- c(
  5, 4,  # -5 < x < 4       <=> -x < 5  &  x < 4
  5, 3,  # -5 < y < 3-x     <=> -y < 5  &  x+y < 3
  10, 6  # -10 < z < 6-x-y  <=> -z < 10  &  x+y+z < 6
)
f <- function(x, y, z) {
  x*y + 5*cos(z)
}
integrateOverPolyhedron(f, A, b)
}
