% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_function.R
\name{fit_g_functions}
\alias{fit_g_functions}
\title{Fit g-functions}
\usage{
fit_g_functions(policy_data, g_models, full_history = FALSE)
}
\arguments{
\item{policy_data}{Policy data object created by \code{\link[=policy_data]{policy_data()}}.}

\item{g_models}{List of action probability models/g-models for each stage
created by \code{\link[=g_empir]{g_empir()}}, \code{\link[=g_glm]{g_glm()}}, \code{\link[=g_rf]{g_rf()}}, \code{\link[=g_sl]{g_sl()}} or similar functions.}

\item{full_history}{If TRUE, the full history is used to fit each g-model.
If FALSE, the single stage/"Markov type" history is used to fit each g-model.}
}
\description{
\code{fit_g_functions} is used to fit a list of g-models.
}
\examples{
library("polle")
### Simulating two-stage policy data
d <- sim_two_stage(2e3, seed=1)
pd <- policy_data(d,
                  action = c("A_1", "A_2"),
                  covariates = list(L = c("L_1", "L_2"),
                                    C = c("C_1", "C_2")),
                  utility = c("U_1", "U_2", "U_3"))
pd

# fitting a single g-model across all stages:
g_functions <- fit_g_functions(policy_data = pd,
                               g_models = g_glm(),
                               full_history = FALSE)
g_functions

# fitting a g-model for each stage:
g_functions <- fit_g_functions(policy_data = pd,
                               g_models = list(g_glm(), g_glm()),
                               full_history = TRUE)
g_functions
}
