% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions__lazy.R
\name{pl_concat_list}
\alias{pl_concat_list}
\title{Concat the arrays in a Series dtype List in linear time.}
\arguments{
\item{exprs}{list of Expr or Series or strings or a mix, or a char vector}
}
\value{
Expr
}
\description{
Folds the expressions from left to right, keeping the first non-null value.
}
\examples{
# Create lagged columns and collect them into a list. This mimics a rolling window.
df = pl$DataFrame(A = c(1, 2, 9, 2, 13))
df$with_columns(lapply(
  0:2,
  \(i) pl$col("A")$shift(i)$alias(paste0("A_lag_", i))
))$select(
  pl$concat_list(lapply(2:0, \(i) pl$col(paste0("A_lag_", i))))$alias(
    "A_rolling"
  )
)

# concat Expr a Series and an R obejct
pl$concat_list(list(
  pl$lit(1:5),
  pl$Series(5:1),
  rep(0L, 5)
))$alias("alice")$lit_to_s()

}
\keyword{Expr_new}
