% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series__series.R
\name{Series_apply}
\alias{Series_apply}
\alias{apply}
\title{Apply every value with an R fun}
\usage{
Series_apply(
  fun,
  datatype = NULL,
  strict_return_type = TRUE,
  allow_fail_eval = FALSE
)
}
\arguments{
\item{fun}{r function, should take a scalar value as input and return one.}

\item{datatype}{DataType of return value. Default NULL means same as input.}

\item{strict_return_type}{bool, default TRUE: fail on wrong return type, FALSE: convert to polars Null}

\item{allow_fail_eval}{bool, default FALSE: raise R fun error, TRUE: convert to polars Null}
}
\value{
Series
}
\description{
About as slow as regular non-vectorized R. Similar to using R sapply on a vector.
}
\examples{
s = pl$Series(letters[1:5], "ltrs")
f = \(x) paste(x, ":", as.integer(charToRaw(x)))
s$apply(f, pl$Utf8)

# same as
pl$Series(sapply(s$to_r(), f), s$name)
}
\keyword{Series}
