% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr__datetime.R
\name{ExprDT_year}
\alias{ExprDT_year}
\alias{(Expr)$dt$year}
\title{Year}
\format{
function
}
\value{
Expr of Year as Int32
}
\description{
Extract year from underlying Date representation.
Applies to Date and Datetime columns.
Returns the year number in the calendar date.
}
\examples{
df = pl$DataFrame(
  date = pl$date_range(
    as.Date("2020-12-25"),
    as.Date("2021-1-05"),
    interval = "1d",
    time_zone = "GMT",
    lazy = FALSE
  )
)
df$with_columns(
  pl$col("date")$dt$year()$alias("year"),
  pl$col("date")$dt$iso_year()$alias("iso_year")
)
}
\keyword{ExprDT}
