% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{thylacine_bounty_record}
\alias{thylacine_bounty_record}
\title{Thylacine vignette bounty record}
\format{
A data frame with 22 rows and 11 variables:
\describe{
\item{Year}{Year during bounty period from 1888 to 1909}
\item{Total}{Total Tasmania-wide bounty submitted}
\item{FUR}{Bounty submitted in IBRA bioregion: Furneaux}
\item{BEN}{Bounty submitted in IBRA bioregion: Ben Lomond}
\item{TNM}{Bounty submitted in IBRA bioregion: Tasmanian Northern Midlands}
\item{TSE}{Bounty submitted in IBRA bioregion: Tasmanian South East}
\item{TW}{Bounty submitted in IBRA bioregion: Tasmanian West}
\item{TNS}{Bounty submitted in IBRA bioregion: Tasmanian Northern Slopes}
\item{TSR}{Bounty submitted in IBRA bioregion: Tasmanian Southern Ranges}
\item{TCH}{Bounty submitted in IBRA bioregion: Tasmanian Central Highlands}
\item{KIN}{Bounty submitted in IBRA bioregion: King}
}
}
\source{
https://doi.org/10.1111/2041-210X.13720
}
\description{
A dataset containing the historical record of the Thylacine bounty numbers submitted
across the Tasmanian study region, and for each of the nine Interim Bioregionalisation
of Australia (IBRA) bioregions for Thylacine example vignette.
}
\examples{
data(thylacine_bounty_record)
summary(thylacine_bounty_record)
# Assuming your data frame is named thylacine_bounty_record
plot(thylacine_bounty_record$Year, thylacine_bounty_record$Total,
  type = "l",
  main = "Change in Total Bounties Over Time",
  xlab = "Year",
  ylab = "Total Bounties"
)

}
