% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step-select.R
\name{step.DV}
\alias{step.DV}
\title{Dumontet--Vignes automatic step selection}
\usage{
step.DV(
  FUN,
  x,
  h0 = 1e-05 * max(abs(x), sqrt(.Machine$double.eps)),
  range = h0/c(1e+06, 1e-06),
  max.rel.error = .Machine$double.eps^(3/4),
  ratio.limits = c(2, 15),
  maxit = 40L,
  cores = 1,
  preschedule = getOption("pnd.preschedule", TRUE),
  cl = NULL,
  diagnostics = FALSE,
  ...
)
}
\arguments{
\item{FUN}{Function for which the optimal numerical derivative step size is needed.}

\item{x}{Numeric scalar: the point at which the derivative is computed and the optimal step size is estimated.}

\item{h0}{Numeric scalar: initial step size, defaulting to a relative step of
slightly greater than .Machine$double.eps^(1/3) (or absolute step if \code{x == 0}). This step
size for first derivarives is internallt translated into the initial step size for third
derivatives by multiplying it by the machine epsilon raised to the power -2/15.}

\item{range}{Numeric vector of length 2 defining the valid search range for the step size.}

\item{max.rel.error}{Positive numeric scalar > 0 indicating the maximum relative
error of function evaluation. For highly accurate functions with all accurate bits
is equal to \code{.Machine$double.eps/2}. For noisy functions (derivatives, integrals,
output of optimisation routines etc.), it is higher, typically
\code{sqrt(.Machine$double.eps)}. Dumontet and Vignes recommend
\code{.Machine$double.eps^(3/4) = 2e-12} for common functions.}

\item{ratio.limits}{Numeric vector of length 2 defining the acceptable ranges
for step size: the algorithm stops if the relative perturbation of the third derivative by
amplified rounding errors falls within this range.}

\item{maxit}{Maximum number of algorithm iterations to avoid infinite loops in cases
the desired relative perturbation factor cannot be achieved within the given \code{range}.
Consider extending the range if this limit is reached.}

\item{cores}{Integer specifying the number of CPU cores used for parallel computation.
Recommended to be set to the number of physical cores on the machine minus one.}

\item{preschedule}{Logical: if \code{TRUE}, disables pre-scheduling for \code{mclapply()}
or enables load balancing with \code{parLapplyLB()}. Recommended for functions that
take less than 0.1 s per evaluation.}

\item{cl}{An optional user-supplied \code{cluster} object  (created by \code{makeCluster}
or similar functions). If not \code{NULL}, the code uses \code{parLapply()} (if \code{preschedule}
is \code{TRUE}) or \code{parLapplyLB()} on that cluster on Windows, and \code{mclapply}
(fork cluster) on everything else.}

\item{diagnostics}{Logical: if \code{TRUE}, returns the full iteration history
including all function evaluations.
Note: the history tracks the third derivative, not the first.}

\item{...}{Passed to FUN.}
}
\value{
A list similar to the one returned by \code{optim()}: \code{par} -- the optimal
step size found, \code{value} -- the estimated numerical first derivative (central
differences), \code{counts} -- the number of iterations (each iteration includes
four function evaluations), \code{abs.error} -- an estimate of the total
approximation error (sum of truncation and rounding errors),
\code{exitcode} -- an integer code indicating the termination status:
\code{0} indicates optimal termination within tolerance,
\code{1} means that the third derivative is zero (large step size preferred),
\code{3} indicates a solution at the boundary of the allowed value range,
\code{4} signals that the maximum number of iterations was reached and the
found optimal step size belongs to the allowed range,
\code{5} occurs when the maximum number of iterations was reached and the
found optimal step size did belong to the allowed range and had to be snapped
to one end.
\code{6} is used when \code{maxit = 1} and no search was performed.
\code{message} is a summary message of the exit status.
If \code{diagnostics} is \code{TRUE}, \code{iterations} is a list
including the full step size search path (NB: for the 3rd derivative),
argument grids, function values on those grids, and estimated 3rd derivative values.
}
\description{
Dumontet--Vignes automatic step selection
}
\details{
This function computes the optimal step size for central differences using the
\insertCite{dumontet1977determination}{pnd} algorithm.
If the estimated third derivative is exactly zero, the function assumes a third
derivative of 1 to prevent division-by-zero errors.
}
\examples{
f <- function(x) x^4
step.DV(x = 2, f)
step.DV(x = 2, f, h0 = 1e-3, diagnostics = TRUE)

# Plug-in estimator with only one evaluation of f'''
step.DV(x = 2, f, maxit = 1)
}
\references{
\insertAllCited{}
}
