% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{PrepareFGSEAResult}
\alias{PrepareFGSEAResult}
\alias{GSEASummaryPlot}
\alias{GSEAPlot}
\title{GSEA plots}
\usage{
PrepareFGSEAResult(data, gene_ranks, gene_sets)

GSEASummaryPlot(
  data,
  gene_ranks = "@gene_ranks",
  gene_sets = "@gene_sets",
  top_term = 10,
  metric = "p.adjust",
  cutoff = 0.05,
  character_width = 50,
  line_plot_size = 0.25,
  metric_name = paste0("-log10(", metric, ")"),
  nonsig_name = "Non-significant",
  linewidth = 0.2,
  line_by = c("prerank", "running_score"),
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  alpha = 0.6,
  aspect.ratio = 1,
  legend.position = "right",
  legend.direction = "vertical",
  theme = "theme_this",
  theme_args = list(),
  palette = "Spectral",
  palcolor = NULL,
  seed = 8525,
  ...
)

GSEAPlot(
  data,
  gene_ranks = "@gene_ranks",
  gene_sets = "@gene_sets",
  sample_coregenes = FALSE,
  line_width = 1.5,
  line_alpha = 1,
  line_color = "#6BB82D",
  n_coregenes = 10,
  genes_label = NULL,
  label_fg = "black",
  label_bg = "white",
  label_bg_r = 0.1,
  label_size = 4,
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  combine = TRUE,
  nrow = NULL,
  ncol = NULL,
  byrow = TRUE,
  seed = 8525,
  axes = NULL,
  axis_titles = axes,
  guides = NULL,
  design = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame of GSEA results
For example, from \code{DOSE::gseDO()}.
Required columns are \code{ID}, \code{Description}, \code{NES}, \code{p.adjust}, \code{pvalue}.
The \code{ID} column is used to match the gene sets.}

\item{gene_ranks}{A numeric vector of gene ranks with genes as names
The gene ranks are used to plot the gene sets.
If \code{gene_ranks} is a character vector starting with \code{@}, the gene ranks will be taken from the attribute of \code{data}.}

\item{gene_sets}{A list of gene sets, typically from a record of a GMT file
The names of the list should match the \code{ID} column of \code{data}.
If \code{gene_sets} is a character vector starting with \code{@}, the gene sets will be taken from the attribute of \code{data}.
The GSEA plots will be plotted for each gene set. So, the number of plots will be the number of gene sets.
If you only want to plot a subset of gene sets, you can subset the \code{gene_sets} before passing it to this function.}

\item{top_term}{An integer to select the top terms}

\item{metric}{The metric to use for the significance of the terms}

\item{cutoff}{The cutoff for the significance of the terms
The terms will not be filtered with this cutoff; they are only filtered by the \code{top_term} ranked by the \code{metric}.
The cutoff here is used to show the significance of the terms on the plot.
For the terms that are not significant, the color will be grey.}

\item{character_width}{The width of the characters in the y-axis}

\item{line_plot_size}{The size of the line plots}

\item{metric_name}{The name of the metric to show in the color bar}

\item{nonsig_name}{The name of the legend for the nonsignificant terms}

\item{linewidth}{The width of the lines in the line plots}

\item{line_by}{The method to calculate the line plots.
\itemize{
\item \code{prerank}: Use the gene ranks as heights to plot the line plots.
\item \code{running_score}: Use the running score to plot the line plots.
}}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{A character string specifying the y-axis label.}

\item{alpha}{A numeric value specifying the transparency of the plot.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{palette}{A character string specifying the palette to use.
A named list or vector can be used to specify the palettes for different \code{split_by} values.}

\item{palcolor}{A character string specifying the color to use in the palette.
A named list can be used to specify the colors for different \code{split_by} values.
If some values are missing, the values from the palette will be used (palcolor will be NULL for those values).}

\item{seed}{The random seed to use. Default is 8525.}

\item{...}{Additional arguments.}

\item{sample_coregenes}{A logical value to sample the core genes from the core_enrichment; if \code{FALSE}, the first \code{n_coregenes} will be used}

\item{line_width}{The width of the line in the running score plot}

\item{line_alpha}{The alpha of the line in the running score plot}

\item{line_color}{The color of the line in the running score plot}

\item{n_coregenes}{The number of core genes to label}

\item{genes_label}{The genes to label. If set, \code{n_coregenes} will be ignored}

\item{label_fg}{The color of the label text}

\item{label_bg}{The background color of the label}

\item{label_bg_r}{The radius of the background color of the label}

\item{label_size}{The size of the label text}

\item{combine}{Whether to combine the plots into one when facet is FALSE. Default is TRUE.}

\item{nrow}{A numeric value specifying the number of rows in the facet.}

\item{ncol}{A numeric value specifying the number of columns in the facet.}

\item{byrow}{A logical value indicating whether to fill the plots by row.}

\item{axes}{A string specifying how axes should be treated. Passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE.
Options are:
\itemize{
\item 'keep' will retain all axes in individual plots.
\item 'collect' will remove duplicated axes when placed in the same run of rows or columns of the layout.
\item 'collect_x' and 'collect_y' will remove duplicated x-axes in the columns or duplicated y-axes in the rows respectively.
}}

\item{axis_titles}{A string specifying how axis titltes should be treated. Passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE.
Options are:
\itemize{
\item 'keep' will retain all axis titles in individual plots.
\item 'collect' will remove duplicated titles in one direction and merge titles in the opposite direction.
\item 'collect_x' and 'collect_y' control this for x-axis titles and y-axis titles respectively.
}}

\item{guides}{A string specifying how guides should be treated in the layout. Passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE.
Options are:
\itemize{
\item 'collect' will collect guides below to the given nesting level, removing duplicates.
\item 'keep' will stop collection at this level and let guides be placed alongside their plot.
\item 'auto' will allow guides to be collected if a upper level tries, but place them alongside the plot if not.
}}

\item{design}{Specification of the location of areas in the layout, passed to \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}}.
Only relevant when \code{split_by} is used and \code{combine} is TRUE. When specified, \code{nrow}, \code{ncol}, and \code{byrow} are ignored.
See \code{\link[patchwork:wrap_plots]{patchwork::wrap_plots()}} for more details.}
}
\value{
A data frame with the desired columns for plotting and the gene ranks and gene sets as attributes
}
\description{
\itemize{
\item \code{GSEASummaryPlot} is used to plot a summary of the results of a GSEA analysis.
\item \code{GSEAPlot} is used to plot the results of a GSEA analysis.
\item \code{PrepareFGSEA} is used to prepare the result of GSEA from the \code{fgsea} package for plotting.
}
}
\examples{
\donttest{
data(gsea_example)
GSEASummaryPlot(gsea_example)
GSEASummaryPlot(gsea_example, line_by = "running_score")
GSEASummaryPlot(gsea_example, cutoff = 0.01)
}
\donttest{
GSEAPlot(gsea_example, gene_sets = attr(gsea_example, "gene_sets")[1])
GSEAPlot(gsea_example, gene_sets = attr(gsea_example, "gene_sets")[1:4])
}
}
