% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_delim.R
\name{process_delim}
\alias{process_delim}
\title{A function to read in large data files as an FBM}
\usage{
process_delim(
  data_dir,
  data_file,
  feature_id,
  rds_dir = data_dir,
  rds_prefix,
  logfile = NULL,
  overwrite = FALSE,
  quiet = FALSE,
  ...
)
}
\arguments{
\item{data_dir}{The directory to the file.}

\item{data_file}{The file to be read in, without the filepath. This should be a file of numeric values.
Example: use \code{data_file = "myfile.txt"}, not \code{data_file = "~/mydirectory/myfile.txt"}
Note: if your file has headers/column names, set 'header = TRUE' -- this will be passed into \code{bigmemory::read.big.matrix()}.}

\item{feature_id}{A string specifying the column in the data X (the feature data) with the row IDs (e.g., identifiers for each row/sample/participant/, etc.). No duplicates allowed.}

\item{rds_dir}{The directory where the user wants to create the '.rds' and '.bk' files
Defaults to \code{data_dir}}

\item{rds_prefix}{String specifying the user's preferred filename for the to-be-created .rds file (will be create insie \code{rds_dir} folder)
Note: 'rds_prefix' cannot be the same as 'data_prefix'}

\item{logfile}{Optional: the name (character string) of the prefix of the
logfile to be written. Defaults to 'process_delim', i.e. you will get 'process_delim.log' as the outfile.}

\item{overwrite}{Optional: the name (character string) of the prefix of the logfile to be written.
Defaults to 'process_plink', i.e. you will get 'process_plink.log' as the outfile.
\strong{Note}: If there are multiple \code{.rds} files with names that start with "std_prefix_...", \strong{this will error out}.
To protect users from accidentally deleting files with saved results, only one \code{.rds} file can be removed with this option.}

\item{quiet}{Logical: should the messages printed to the console be silenced? Defaults to FALSE.}

\item{...}{Optional: other arguments to be passed to \code{bigmemory::read.big.matrix()}. Note: 'sep' is an option to pass here, as is 'header'.}
}
\value{
The file path to the newly created '.rds' file
}
\description{
A function to read in large data files as an FBM
}
\examples{
temp_dir <- tempdir()
colon_dat <- process_delim(data_file = "colon2.txt",
 data_dir = find_example_data(parent = TRUE), overwrite = TRUE,
 rds_dir = temp_dir, rds_prefix = "processed_colon2", sep = "\t", header = TRUE)

colon2 <- readRDS(colon_dat)
str(colon2)

}
