% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bed.R
\name{readBED}
\alias{readBED}
\title{Read BED file}
\usage{
readBED(pfx, row = NULL, col = NULL, quiet = TRUE)
}
\arguments{
\item{pfx}{prefix of PLINK file set, or the fullname of a BED file.}

\item{row}{the row names: 1 =  use individual ID, 2 =  family and individual
ID, def = NULL.}

\item{col}{the column names: 1 =  use variant ID (i.e., rsID), 2 = CHR:POS, 3
= CHR:POS_A1_A2}

\item{quiet}{suppress screen printing? (def=TRUE)}
}
\value{
genotype matrix with row individuals and column variants.
}
\description{
Read a BED file into a R matrix. This is meant for in-of-memory process of moderate
to small sized genotype.
}
\details{
To scan a huge BED one varant at time without reading it into the memoty, see
\code{\link{scanBED}} instead.

A BED (\emph{binary biallelic genotype table}) is comprised of three files
(usually) sharing identical prefix:
\itemize{
  \item {pfx}.fam: table of N typed individuals
  \item {pfx}.bim: table of P typed genomic variants (i.e., SNPs);
  \item {pfx}.bed: genotype matrix of N rows and P columns stored in condensed
  binary format.
}

The three files are commonly referred by their common prefix, e.g.:

chrX.bed, chrX.fam, and chrX.bim, are jointly specified by "chrX".
}
\examples{
bed <- system.file("extdata", 'm20.bed', package="plinkFile")
pfx <- sub("[.]bed$", "", bed)
bed <- readBED(pfx, quiet=FALSE)

}
\seealso{
{readBED}
}
