% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pc_map.R
\name{pc_map}
\alias{pc_map}
\title{Principal component heatmap in a plate layout}
\usage{
pc_map(data, well, plate = 96)
}
\arguments{
\item{data}{Vector of numerical data to calculate the first principal component}

\item{well}{Vector of well identifiers e.g "A01"}

\item{plate}{Number of wells in complete plate (96, 384 or 1536}
}
\value{
gplot plot
}
\description{
Takes the values and well identifiers, calculates the first principal
component, scales and plots the component as a heatmap in the form of
a 96 or 384-well plate. A way to quickly show variation of
multi-parametric data within a plate.
}
\examples{
df <- data.frame(
  well = num_to_well(1:96),
  vals1 = rnorm(1:96),
  vals2 = rnorm(1:96))

pc_map(data = df[, 2:3],
       well = df$well,
       plate = 384)
}

