% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crandb-public-api.R, R/print.R
\name{cran_events}
\alias{cran_events}
\alias{summary.cran_event_list}
\alias{print.cran_event_list}
\title{List of all CRAN events (new, updated, archived packages)}
\usage{
cran_events(releases = TRUE, archivals = TRUE, limit = 10, from = 1)

\method{summary}{cran_event_list}(object, ...)

\method{print}{cran_event_list}(x, ...)
}
\arguments{
\item{releases}{Whether to include package releases.}

\item{archivals}{Whether to include package archivals.}

\item{limit}{Number of events to list.}

\item{from}{Where to start the list, for pagination.}

\item{object}{Object to summarize.}

\item{...}{Additional arguments are ignored currently.}

\item{x}{Object to print.}
}
\value{
List of events.
}
\description{
List of all CRAN events (new, updated, archived packages)
}
\examples{
\dontshow{ asNamespace("pkgsearch")$exif(pingr::is_online(), \{ }
cran_events()
cran_events(limit = 5, releases = FALSE)
cran_events(limit = 5, archivals = FALSE)
summary(cran_events(limit = 10))
\dontshow{ \}) }
}
