% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inch_mm.R
\name{inch_mm}
\alias{inch_mm}
\title{Millimeters to inches}
\usage{
inch_mm(x)
}
\arguments{
\item{x}{length measured in \emph{millimeters}, [\emph{mm}].
Type: \code{\link{assert_double}}.}
}
\value{
length in \emph{inches}, [\emph{inch}].
 Type: \code{\link{assert_double}}.
}
\description{
Convert length measured in \href{https://en.wikipedia.org/wiki/Millimetre}{millimeters} (mm)
 to \href{https://en.wikipedia.org/wiki/Inch}{inches}
}
\examples{
 inch_mm(c(25.4, 1))
 # [1] 1.00000000 0.03937008  # [inch]


}
\seealso{
\code{\link{mm_inch}} for converting \emph{inches} to \emph{mm}

Other utils: 
\code{\link{kgf_mpa}()},
\code{\link{mm_inch}()},
\code{\link{mpa_kgf}()},
\code{\link{mpa_psi}()},
\code{\link{psi_mpa}()}
}
\concept{utils}
