% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin-meta.R
\name{pin_meta}
\alias{pin_meta}
\title{Retrieve metadata for a pin}
\usage{
pin_meta(board, name, version = NULL, ...)
}
\arguments{
\item{board}{A pin board, created by \code{\link[=board_folder]{board_folder()}}, \code{\link[=board_connect]{board_connect()}},
\code{\link[=board_url]{board_url()}} or another \code{board_} function.}

\item{name}{Pin name.}

\item{version}{Retrieve a specific version of a pin. Use \code{\link[=pin_versions]{pin_versions()}} to
find out which versions are available and when they were created.}

\item{...}{Additional arguments passed on to methods for a specific board.}
}
\value{
A list.
}
\description{
Pin metadata comes from three sources:
\itemize{
\item Standard metadata added by \code{pin_upload()}/\code{pin_write()}. This includes:
\itemize{
\item \verb{$name} - the pin's name.
\item \verb{$file} - names of files stored in the pin.
\item \verb{$file_size} - size of each file.
\item \verb{$pin_hash} - hash of pin contents.
\item \verb{$type} - type of pin: "rds", "csv", etc
\item \verb{$title} - pin title
\item \verb{$description} - pin description
\item \verb{$tags} - pin tags
\item \verb{$created} - date this (version of the pin) was created
\item \verb{$api_version} - API version used by pin
}
\item Metadata supplied by the user, stored in \verb{$user}. This is untouched
from what is supplied in \code{\link[=pin_write]{pin_write()}}/\code{\link[=pin_upload]{pin_upload()}} except for being
converted to and from to YAML.
\item Local metadata generated when caching the pin, stored in \verb{$local}.
This includes information like the version of the pin, and the path
its local cache.
}
}
\examples{
b <- board_temp()
b \%>\% pin_write(head(mtcars), "mtcars", metadata = list("Hadley" = TRUE))

# Get the pin
b \%>\% pin_read("mtcars")
# Get its metadata
b \%>\% pin_meta("mtcars")
# Get path to underlying data
b \%>\% pin_download("mtcars")

# Use tags instead
b \%>\% pin_write(tail(mtcars), "mtcars", tags = c("fuel-efficiency", "automotive"))
b \%>\% pin_meta("mtcars")

}
